/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.arima;

import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.RationalFunction;
import ec.tstoolkit.ssf.IFilteringResults;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.ISsfInitializer;
import ec.tstoolkit.ssf.SsfException;
import ec.tstoolkit.ssf.State;
import ec.tstoolkit.ssf.arima.SsfBaseArima;

public final class SsfArima
extends SsfBaseArima {
    double[] m_dif;
    double[] m_stacgf;
    double[] m_stpsi;

    public static void B0(SubMatrix b, double[] d) {
        int nd = d.length - 1;
        if (nd == 0) {
            return;
        }
        int nr = b.getRowsCount();
        for (int i = 0; i < nd; ++i) {
            b.set(i, i, 1.0);
            for (int k = nd; k < nr; ++k) {
                double w = 0.0;
                for (int l = 1; l <= nd; ++l) {
                    w -= d[l] * b.get(k - l, i);
                }
                b.set(k, i, w);
            }
        }
    }

    public static void Ksi(SubMatrix X, double[] dif) {
        int n = X.getRowsCount();
        double[] ksi = new RationalFunction(Polynomial.ONE, Polynomial.of(dif)).coefficients(n);
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k <= j; ++k) {
                X.set(j, k, ksi[j - k]);
            }
        }
    }

    public static void stVar(SubMatrix stV, double[] stpsi, double[] stacgf, double var) {
        int j;
        int n = stV.getRowsCount();
        for (j = 0; j < n; ++j) {
            stV.set(j, 0, stacgf[j]);
        }
        for (j = 0; j < n - 1; ++j) {
            stV.set(j + 1, j + 1, stV.get(j, j) - stpsi[j] * stpsi[j] * var);
            for (int k = 0; k < j; ++k) {
                stV.set(j + 1, k + 1, stV.get(j, k) - stpsi[j] * stpsi[k] * var);
            }
        }
        SymmetricMatrix.fromLower(stV);
    }

    public SsfArima(IArimaModel arima) {
        super(arima);
        this.initModel();
    }

    @Override
    public void diffuseConstraints(SubMatrix pm) {
        int d = this.m_dif.length - 1;
        if (d == 0) {
            return;
        }
        SsfArima.B0(pm, this.m_dif);
    }

    @Override
    public int getNonStationaryDim() {
        return this.m_dif.length - 1;
    }

    @Override
    protected void initModel() {
        double var = this.m_model.getInnovationVariance();
        if (var == 0.0) {
            throw new SsfException("Invalid stochastic model");
        }
        BackFilter ur = this.m_model.getNonStationaryAR();
        this.m_dif = ur.getCoefficients();
        Polynomial phi = this.m_model.getAR().getPolynomial();
        this.m_phi = phi.getCoefficients();
        this.m_Phi = new DataBlock(this.m_phi, 1, this.m_phi.length, 1);
        Polynomial theta = this.m_model.getMA().getPolynomial();
        this.m_dim = Math.max(phi.getDegree(), theta.getDegree() + 1);
        this.m_psi = new RationalFunction(theta, phi).coefficients(this.m_dim);
        Polynomial stphi = this.m_model.getStationaryAR().getPolynomial();
        this.m_stacgf = new AutoCovarianceFunction(theta, stphi, var).values(this.m_dim);
        this.m_stpsi = new RationalFunction(theta, stphi).coefficients(this.m_dim);
        this.m_tmp = new double[this.m_dim];
    }

    @Override
    public boolean isDiffuse() {
        return this.m_dif.length > 1;
    }

    @Override
    public void Pf0(SubMatrix pm) {
        Matrix stV = new Matrix(this.m_dim, this.m_dim);
        SsfArima.stVar(stV.subMatrix(), this.m_stpsi, this.m_stacgf, this.m_model.getInnovationVariance());
        Matrix K = new Matrix(this.m_dim, this.m_dim);
        SsfArima.Ksi(K.subMatrix(), this.m_dif);
        SymmetricMatrix.quadraticFormT(stV.subMatrix(), K.subMatrix(), pm);
    }

    @Override
    public void Pi0(SubMatrix pm) {
        Matrix B = new Matrix(this.m_dim, this.m_dif.length - 1);
        SsfArima.B0(B.subMatrix(), this.m_dif);
        SymmetricMatrix.XXt(B.subMatrix(), pm);
    }

    public static class Initializer
    implements ISsfInitializer<SsfArima> {
        public void calcInitialState(SsfArima ssf, DataBlock a, ISsfData data) {
            int nr = ssf.m_dim;
            int nd = ssf.m_dif.length - 1;
            Matrix A = new Matrix(nr + nd, nd);
            for (int j = 0; j < nd; ++j) {
                A.set(j, j, 1.0);
                for (int i = nd; i < nd + nr; ++i) {
                    double c = 0.0;
                    for (int k = 1; k <= nd; ++k) {
                        c -= ssf.m_dif[k] * A.get(i - k, j);
                    }
                    A.set(i, j, c);
                }
            }
            for (int i = 0; i < nr; ++i) {
                double c = 0.0;
                for (int j = 0; j < nd; ++j) {
                    c += A.get(i + nd, j) * data.get(j);
                }
                a.set(i, c);
            }
        }

        @Override
        public int initialize(SsfArima ssf, ISsfData data, State state, IFilteringResults rslts) {
            int d = ssf.m_dif.length - 1;
            if (d == 0) {
                ssf.Pf0(state.P.subMatrix());
            } else {
                this.calcInitialState(ssf, state.A, data);
                int dim = ssf.m_dim;
                Matrix stV = new Matrix(dim, dim);
                SsfArima.stVar(stV.subMatrix(), ssf.m_stpsi, ssf.m_stacgf, ssf.m_model.getInnovationVariance());
                Matrix K = new Matrix(dim, dim);
                SsfArima.Ksi(K.subMatrix(), ssf.m_dif);
                SymmetricMatrix.quadraticFormT(stV.subMatrix(), K.subMatrix(), state.P.subMatrix());
            }
            return d;
        }
    }
}

