/*
 * Decompiled with CFR 0.152.
 */
package ActiveSubnetworkSearchMisc;

public class Gaussian {
    public static double pdf(double x) {
        return Math.exp(-x * x / 2.0) / Math.sqrt(Math.PI * 2);
    }

    public static double pdf(double x, double mu, double sigma) {
        return Gaussian.pdf((x - mu) / sigma) / sigma;
    }

    public static double cdf(double z) {
        if (z < -8.0) {
            return 0.0;
        }
        if (z > 8.0) {
            return 1.0;
        }
        double sum = 0.0;
        double term = z;
        int i = 3;
        while (sum + term != sum) {
            sum += term;
            term = term * z * z / (double)i;
            i += 2;
        }
        return 0.5 + sum * Gaussian.pdf(z);
    }

    public static double cdf(double z, double mu, double sigma) {
        return Gaussian.cdf((z - mu) / sigma);
    }

    public static double inverseCDF(double y) {
        return Gaussian.inverseCDF(y, 1.0E-8, -8.0, 8.0);
    }

    private static double inverseCDF(double y, double delta, double lo, double hi) {
        double mid = lo + (hi - lo) / 2.0;
        if (hi - lo < delta) {
            return mid;
        }
        if (Gaussian.cdf(mid) > y) {
            return Gaussian.inverseCDF(y, delta, lo, mid);
        }
        return Gaussian.inverseCDF(y, delta, mid, hi);
    }
}

