/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jd2.workspace.WorkspaceFamily;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

final class Index {
    @lombok.NonNull
    private final String name;
    @lombok.NonNull
    private final Map<Key, Value> items;

    public @NonNull Index withItem(@NonNull Key key, @NonNull Value value) {
        return this.toBuilder().item(key, value).build();
    }

    public @NonNull Index withoutItem(@NonNull Key key) {
        Builder result = Index.builder().name(this.getName());
        this.getItems().forEach((k, v) -> {
            if (!k.equals(key)) {
                result.item((Key)k, (Value)v);
            }
        });
        return result.build();
    }

    @Generated
    Index(@lombok.NonNull String name, @lombok.NonNull Map<Key, Value> items) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.name = name;
        this.items = items;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        Builder builder = new Builder().name(this.name);
        if (this.items != null) {
            builder.items(this.items);
        }
        return builder;
    }

    @lombok.NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @lombok.NonNull
    @Generated
    public Map<Key, Value> getItems() {
        return this.items;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Index)) {
            return false;
        }
        Index other = (Index)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<Key, Value> this$items = this.getItems();
        Map<Key, Value> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<Key, Value> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Index(name=" + this.getName() + ", items=" + this.getItems() + ")";
    }

    @Generated
    public Index withName(@lombok.NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new Index(name, this.items);
    }

    @Generated
    public static class Builder {
        @Generated
        private String name;
        @Generated
        private ArrayList<Key> items$key;
        @Generated
        private ArrayList<Value> items$value;

        @Generated
        Builder() {
        }

        @Generated
        public Builder name(@lombok.NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public Builder item(Key itemKey, Value itemValue) {
            if (this.items$key == null) {
                this.items$key = new ArrayList();
                this.items$value = new ArrayList();
            }
            this.items$key.add(itemKey);
            this.items$value.add(itemValue);
            return this;
        }

        @Generated
        public Builder items(Map<? extends Key, ? extends Value> items) {
            if (items == null) {
                throw new NullPointerException("items cannot be null");
            }
            if (this.items$key == null) {
                this.items$key = new ArrayList();
                this.items$value = new ArrayList();
            }
            for (Map.Entry<? extends Key, ? extends Value> $lombokEntry : items.entrySet()) {
                this.items$key.add($lombokEntry.getKey());
                this.items$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public Builder clearItems() {
            if (this.items$key != null) {
                this.items$key.clear();
                this.items$value.clear();
            }
            return this;
        }

        @Generated
        public Index build() {
            Map<Key, Value> items;
            switch (this.items$key == null ? 0 : this.items$key.size()) {
                case 0: {
                    items = Collections.emptyMap();
                    break;
                }
                case 1: {
                    items = Collections.singletonMap(this.items$key.get(0), this.items$value.get(0));
                    break;
                }
                default: {
                    items = new LinkedHashMap<Key, Value>(this.items$key.size() < 0x40000000 ? 1 + this.items$key.size() + (this.items$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.items$key.size(); ++$i) {
                        items.put(this.items$key.get($i), this.items$value.get($i));
                    }
                    items = Collections.unmodifiableMap(items);
                }
            }
            return new Index(this.name, items);
        }

        @Generated
        public String toString() {
            return "Index.Builder(name=" + this.name + ", items$key=" + this.items$key + ", items$value=" + this.items$value + ")";
        }
    }

    public static final class Key {
        @lombok.NonNull
        private final WorkspaceFamily family;
        @lombok.NonNull
        private final String id;

        @Generated
        public Key(@lombok.NonNull WorkspaceFamily family, @lombok.NonNull String id) {
            if (family == null) {
                throw new NullPointerException("family is marked non-null but is null");
            }
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.family = family;
            this.id = id;
        }

        @lombok.NonNull
        @Generated
        public WorkspaceFamily getFamily() {
            return this.family;
        }

        @lombok.NonNull
        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            WorkspaceFamily this$family = this.getFamily();
            WorkspaceFamily other$family = other.getFamily();
            if (this$family == null ? other$family != null : !((Object)this$family).equals(other$family)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WorkspaceFamily $family = this.getFamily();
            result = result * 59 + ($family == null ? 43 : ((Object)$family).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Index.Key(family=" + this.getFamily() + ", id=" + this.getId() + ")";
        }
    }

    public static final class Value {
        private final String label;
        private final boolean readOnly;
        private final String comments;

        @Generated
        public Value(String label, boolean readOnly, String comments) {
            this.label = label;
            this.readOnly = readOnly;
            this.comments = comments;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public boolean isReadOnly() {
            return this.readOnly;
        }

        @Generated
        public String getComments() {
            return this.comments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value other = (Value)o;
            if (this.isReadOnly() != other.isReadOnly()) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$comments = this.getComments();
            String other$comments = other.getComments();
            return !(this$comments == null ? other$comments != null : !this$comments.equals(other$comments));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isReadOnly() ? 79 : 97);
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $comments = this.getComments();
            result = result * 59 + ($comments == null ? 43 : $comments.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Index.Value(label=" + this.getLabel() + ", readOnly=" + this.isReadOnly() + ", comments=" + this.getComments() + ")";
        }
    }
}

