/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.DiffuseState;
import ec.tstoolkit.ssf.IDiffuseFilteringResults;
import ec.tstoolkit.ssf.IFilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.ISsfInitializer;
import ec.tstoolkit.ssf.SsfException;
import ec.tstoolkit.ssf.State;

public class DurbinKoopmanInitializer
implements ISsfInitializer<ISsf> {
    private ISsf m_ssf;
    private IDiffuseFilteringResults m_frslts;
    private int m_r;
    private double m_norm = 0.0;
    private boolean m_qinit;
    int[] m_idxR;
    Matrix m_Q;
    Matrix m_WQW;
    Matrix m_W;

    private void addQ(int pos, Matrix P) {
        if (!this.m_ssf.hasTransitionRes(pos)) {
            return;
        }
        if (this.m_WQW != null) {
            if (!this.m_ssf.hasR()) {
                P.add(this.m_WQW);
            } else {
                int nr = this.m_idxR.length;
                for (int i = 0; i < nr; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        double w = this.m_WQW.get(i, j);
                        P.add(this.m_idxR[i], this.m_idxR[j], w);
                        if (i == j) continue;
                        P.add(this.m_idxR[j], this.m_idxR[i], w);
                    }
                }
            }
        }
    }

    protected void EPredDiffuse(int pos, ISsfData data, DiffuseState state) {
        state.fi = this.m_ssf.ZVZ(pos, state.Pi.subMatrix());
        if (Math.abs(state.fi) < 1.0E-6) {
            state.fi = 0.0;
        }
        state.f = this.m_ssf.ZVZ(pos, state.P.subMatrix());
        if (Math.abs(state.f) / this.m_norm < 1.0E-6) {
            state.f = 0.0;
        }
        if (data.hasData()) {
            double y = data.get(pos);
            if (Double.isNaN(y)) {
                state.e = Double.NaN;
                return;
            }
            state.e = y - this.m_ssf.ZX(pos, state.A);
        }
        this.m_ssf.ZM(pos, state.P.subMatrix(), state.C);
        this.m_ssf.TX(pos, state.C);
        if (state.fi != 0.0) {
            this.m_ssf.ZM(pos, state.Pi.subMatrix(), state.Ci);
            this.m_ssf.TX(pos, state.Ci);
        }
    }

    private boolean getModelInfo(int pos) {
        try {
            if (!this.m_ssf.hasTransitionRes(pos) || this.m_qinit && this.m_ssf.isTransitionEquationTimeInvariant()) {
                return true;
            }
            if (this.m_idxR != null && this.m_ssf.hasR()) {
                SubArrayOfInt R = SubArrayOfInt.create(this.m_idxR);
                R.set(0);
                this.m_ssf.R(pos, R);
            }
            if (this.m_Q != null) {
                this.m_Q.set(0.0);
                this.m_ssf.Q(pos, this.m_Q.subMatrix());
            }
            if (this.m_W != null && this.m_ssf.hasW()) {
                this.m_W.set(0.0);
                this.m_ssf.W(pos, this.m_W.subMatrix());
                SymmetricMatrix.quadraticFormT(this.m_Q.subMatrix(), this.m_W.subMatrix(), this.m_WQW.subMatrix());
                if (this.m_ssf.isTransitionEquationTimeInvariant()) {
                    this.m_qinit = true;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initialize() {
        int rescount = this.m_ssf.getTransitionResCount();
        int resdim = this.m_ssf.getTransitionResDim();
        this.m_qinit = false;
        if (rescount != 0) {
            this.m_Q = new Matrix(resdim, resdim);
            this.m_idxR = (int[])(this.m_ssf.hasR() ? new int[rescount] : null);
            this.m_W = this.m_ssf.hasW() ? new Matrix(rescount, resdim) : null;
            this.m_WQW = this.m_W == null ? this.m_Q : new Matrix(rescount, rescount);
        }
        this.getModelInfo(0);
    }

    @Override
    public int initialize(ISsf ssf, ISsfData data, State state, IFilteringResults rslts) {
        this.m_ssf = ssf;
        this.m_r = ssf.getStateDim();
        this.m_frslts = rslts instanceof IDiffuseFilteringResults ? (IDiffuseFilteringResults)rslts : null;
        this.initialize();
        int pos = 0;
        int end = data.getCount();
        DiffuseState dstate = new DiffuseState(this.m_ssf.getStateDim(), data.hasData());
        this.initState(data, dstate);
        if (this.m_frslts != null) {
            this.m_frslts.prepareDiffuse(this.m_ssf, data);
        }
        if (this.m_ssf.isDiffuse()) {
            do {
                if (!this.m_ssf.isTimeInvariant() && !this.getModelInfo(pos)) {
                    throw new SsfException("Error in diffuse initialization");
                }
                this.EPredDiffuse(pos, data, dstate);
                if (this.m_frslts != null) {
                    this.m_frslts.save(pos, dstate);
                }
                this.nextDiffuse(pos, data, dstate);
            } while (++pos < end && !this.isNull(dstate.Pi));
        }
        if (this.m_frslts != null) {
            this.m_frslts.closeDiffuse();
        }
        state.P = dstate.P;
        state.C = dstate.C;
        state.A = dstate.A;
        state.e = dstate.e;
        state.f = dstate.f;
        return pos;
    }

    private void initState(ISsfData data, DiffuseState state) {
        double[] a0 = data.getInitialState();
        if (a0 != null) {
            state.A.copyFrom(a0, 0);
        }
        this.m_ssf.Pf0(state.P.subMatrix());
        this.m_ssf.Pi0(state.Pi.subMatrix());
        this.m_norm = state.Pi.nrm2();
    }

    private boolean isNull(Matrix P) {
        return P.isZero(1.0E-6 * this.m_norm);
    }

    private void nextDiffuse(int pos, ISsfData data, DiffuseState state) {
        if (state.isMissing()) {
            this.nextMissingDiffuse(pos, data, state);
        } else if (state.fi == 0.0) {
            this.nextDiffuse0(pos, data, state);
        } else {
            this.nextDiffuse1(pos, data, state);
        }
    }

    private void nextDiffuse0(int pos, ISsfData data, DiffuseState state) {
        double c;
        this.m_ssf.TVT(pos, state.P.subMatrix());
        this.m_ssf.TVT(pos, state.Pi.subMatrix());
        DataBlockIterator cols = state.P.columns();
        DataBlock col = cols.getData();
        int icol = 0;
        do {
            c = -state.C.get(icol) / state.f;
            if (icol > 0) {
                col.drop(icol, 0).addAY(c, state.C.drop(icol, 0));
            } else {
                col.addAY(c, state.C);
            }
            ++icol;
        } while (cols.next());
        SymmetricMatrix.fromLower(state.P);
        this.addQ(pos, state.P);
        if (data.hasData()) {
            this.m_ssf.TX(pos, state.A);
            c = state.e / state.f;
            state.A.addAY(c, state.C);
        }
    }

    private void nextDiffuse1(int pos, ISsfData data, DiffuseState state) {
        double c;
        double f1 = 1.0 / state.fi;
        double f2 = -state.f * f1 * f1;
        this.m_ssf.TVT(pos, state.Pi.subMatrix());
        DataBlockIterator cols = state.Pi.columns();
        DataBlock col = cols.getData();
        int icol = 0;
        do {
            c = -state.Ci.get(icol) * f1;
            if (icol > 0) {
                col.drop(icol, 0).addAY(c, state.Ci.drop(icol, 0));
            } else {
                col.addAY(c, state.Ci);
            }
            ++icol;
        } while (cols.next());
        SymmetricMatrix.fromLower(state.Pi);
        this.m_ssf.TVT(pos, state.P.subMatrix());
        cols = state.P.columns();
        col = cols.getData();
        icol = 0;
        do {
            c = f2 * state.Ci.get(icol) + f1 * state.C.get(icol);
            if (icol > 0) {
                col.drop(icol, 0).addAY(-c, state.Ci.drop(icol, 0));
            } else {
                col.addAY(-c, state.Ci);
            }
            ++icol;
        } while (cols.next());
        cols.begin();
        icol = 0;
        do {
            c = f1 * state.Ci.get(icol);
            if (icol > 0) {
                col.drop(icol, 0).addAY(-c, state.C.drop(icol, 0));
            } else {
                col.addAY(-c, state.C);
            }
            ++icol;
        } while (cols.next());
        SymmetricMatrix.fromLower(state.P);
        this.addQ(pos, state.P);
        if (data.hasData()) {
            this.m_ssf.TX(pos, state.A);
            double q = f1 * state.e;
            state.A.addAY(q, state.Ci);
        }
    }

    private void nextMissingDiffuse(int pos, ISsfData data, DiffuseState state) {
        this.m_ssf.TVT(pos, state.P.subMatrix());
        this.m_ssf.TVT(pos, state.Pi.subMatrix());
        this.addQ(pos, state.P);
        this.m_ssf.TX(pos, state.A);
    }
}

