/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.IntUtilities;
import ec.tstoolkit.maths.polynomials.IRootsSolver;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;

public class UnitRootsSolver
implements IRootsSolver {
    private Polynomial m_remainder;
    private UnitRoots m_roots;
    private int m_start = 12;
    private static final double EPS = 1.0E-12;

    private static double pnorm(Polynomial p, int n) {
        if (n == 1) {
            double x = p.evaluateAt(1.0);
            return Math.abs(x);
        }
        if (n == 2) {
            double x = p.evaluateAt(-1.0);
            return Math.abs(x);
        }
        double x = Math.PI * 2 / (double)n;
        Complex c = Complex.cart(Math.cos(x), Math.sin(x));
        Complex val = p.evaluateAt(c);
        return val.abs();
    }

    public UnitRootsSolver() {
    }

    public UnitRootsSolver(int start) {
        this.m_start = start;
    }

    @Override
    public void clear() {
        this.m_roots = null;
        this.m_remainder = null;
    }

    @Override
    public boolean factorize(Polynomial p) {
        this.m_roots = new UnitRoots();
        this.m_remainder = this.process(p, this.m_roots);
        return this.m_roots.getRootsCount() != 0;
    }

    public UnitRoots getUnitRoots() {
        return this.m_roots;
    }

    private Polynomial process(Polynomial p, UnitRoots ur) {
        int num = this.m_start == 0 ? p.getDegree() * 2 + 1 : this.m_start;
        int[] divs = new int[num];
        UnitRoots tmp = new UnitRoots();
        Polynomial cur = p;
        while (num >= 1) {
            if (UnitRootsSolver.pnorm(cur, num) < 1.0E-12) {
                tmp.add(num);
                int ndiv = IntUtilities.divisors(num, divs);
                for (int cdiv = ndiv - 1; cdiv >= 0; --cdiv) {
                    if (!(UnitRootsSolver.pnorm(cur, divs[cdiv]) > 1.0E-12)) continue;
                    tmp.removeOnly(divs, cdiv);
                }
                Polynomial q = UnitRoots.divide(cur, tmp);
                if (q != null) {
                    cur = q;
                    ur.add(tmp);
                } else {
                    --num;
                }
                tmp.clear();
                continue;
            }
            --num;
        }
        return cur;
    }

    @Override
    public Polynomial remainder() {
        return this.m_remainder;
    }

    @Override
    public Complex[] roots() {
        return this.m_roots == null ? null : this.m_roots.roots();
    }

    @Override
    public UnitRootsSolver exemplar() {
        UnitRootsSolver solver = new UnitRootsSolver(this.m_start);
        return solver;
    }
}

