/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.special;

import ec.satoolkit.IDefaultSeriesDecomposer;
import ec.satoolkit.IPreprocessingFilter;
import ec.satoolkit.special.MixedAirlineResults;
import ec.tstoolkit.arima.special.MaSpecification;
import ec.tstoolkit.arima.special.MixedAirlineMonitor;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.timeseries.simplets.TsData;

public class MixedAirlineDecomposer
implements IDefaultSeriesDecomposer<MixedAirlineResults> {
    private final MaSpecification spec_;
    private MixedAirlineResults results_;

    public MixedAirlineDecomposer(MaSpecification decompositionSpec) {
        this.spec_ = decompositionSpec;
    }

    @Override
    public boolean decompose(PreprocessingModel model, IPreprocessingFilter filter) {
        TsData y;
        MixedAirlineMonitor monitor = new MixedAirlineMonitor();
        MaSpecification spec = this.spec_.clone();
        if (model.estimation != null && model.estimation.getArima().isAirline(true)) {
            spec.airline = model.estimation.getArima();
        }
        if (!monitor.process(y = filter.getCorrectedSeries(true), spec)) {
            return false;
        }
        this.results_ = new MixedAirlineResults(y, monitor, model.description.getTransformation() == DefaultTransformationType.Log);
        return true;
    }

    @Override
    public boolean decompose(TsData y) {
        MixedAirlineMonitor monitor = new MixedAirlineMonitor();
        MaSpecification spec = this.spec_.clone();
        if (!monitor.process(y, spec)) {
            return false;
        }
        this.results_ = new MixedAirlineResults(y, monitor, false);
        return true;
    }

    @Override
    public MixedAirlineResults getDecomposition() {
        return this.results_;
    }
}

