/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.seats.IBiasCorrector;
import ec.satoolkit.seats.SeatsContext;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.arima.LogForecasts;
import ec.tstoolkit.timeseries.simplets.TsData;

public class DefaultBiasCorrector
implements IBiasCorrector {
    @Override
    public DefaultSeriesDecomposition correct(ISeriesDecomposition model, InformationSet info, SeatsContext context) {
        if (context.isLogTransformed()) {
            return this.correctLogs(model);
        }
        return this.correctLevels(model);
    }

    private double bias(TsData s, int n) {
        DataBlock d = new DataBlock(s.internalStorage(), 0, n, 1);
        return d.sum() / (double)n;
    }

    private TsData correctStdevForLog(TsData e, TsData s) {
        TsData ec = new TsData(e.getDomain());
        for (int i = 0; i < ec.getLength(); ++i) {
            ec.set(i, LogForecasts.expStdev2(e.get(i), s.get(i)));
        }
        return ec;
    }

    private DefaultSeriesDecomposition correctLevels(ISeriesDecomposition model) {
        TsData ft;
        TsData fs;
        TsData fy;
        TsData t;
        TsData y = model.getSeries(ComponentType.Series, ComponentInformation.Value);
        if (y == null) {
            return null;
        }
        DefaultSeriesDecomposition decomp = new DefaultSeriesDecomposition(DecompositionMode.Additive);
        decomp.add(y, ComponentType.Series);
        TsData s = model.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
        if (s != null) {
            decomp.add(s, ComponentType.Seasonal);
            TsData se = model.getSeries(ComponentType.Seasonal, ComponentInformation.Stdev);
            if (se != null) {
                decomp.add(se, ComponentType.Seasonal, ComponentInformation.Stdev);
            }
        }
        if ((t = model.getSeries(ComponentType.Trend, ComponentInformation.Value)) != null) {
            decomp.add(t, ComponentType.Trend);
            TsData te = model.getSeries(ComponentType.Trend, ComponentInformation.Stdev);
            if (te != null) {
                decomp.add(te, ComponentType.Trend, ComponentInformation.Stdev);
            }
        }
        TsData sa = TsData.subtract(y, s);
        decomp.add(sa, ComponentType.SeasonallyAdjusted);
        TsData sae = model.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
        if (sae != null) {
            decomp.add(sae, ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
        }
        TsData i = TsData.subtract(sa, t);
        decomp.add(i, ComponentType.Irregular);
        TsData ie = model.getSeries(ComponentType.Irregular, ComponentInformation.Stdev);
        if (ie != null) {
            decomp.add(ie, ComponentType.Irregular, ComponentInformation.Stdev);
        }
        if ((fy = model.getSeries(ComponentType.Series, ComponentInformation.Forecast)) != null) {
            decomp.add(fy, ComponentType.Series, ComponentInformation.Forecast);
            TsData fye = model.getSeries(ComponentType.Series, ComponentInformation.StdevForecast);
            if (fye != null) {
                decomp.add(fye, ComponentType.Series, ComponentInformation.StdevForecast);
            }
        }
        if ((fs = model.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast)) != null) {
            decomp.add(fs, ComponentType.Seasonal, ComponentInformation.Forecast);
            TsData fse = model.getSeries(ComponentType.Seasonal, ComponentInformation.StdevForecast);
            if (fse != null) {
                decomp.add(fse, ComponentType.Seasonal, ComponentInformation.StdevForecast);
            }
        }
        if ((ft = model.getSeries(ComponentType.Trend, ComponentInformation.Forecast)) != null) {
            decomp.add(ft, ComponentType.Trend, ComponentInformation.Forecast);
            TsData fte = model.getSeries(ComponentType.Trend, ComponentInformation.StdevForecast);
            if (fte != null) {
                decomp.add(fte, ComponentType.Trend, ComponentInformation.StdevForecast);
            }
        }
        TsData fsa = TsData.subtract(fy, fs);
        decomp.add(fsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
        TsData fsae = model.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
        if (fsae != null) {
            decomp.add(fsae, ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
        }
        TsData fi = TsData.subtract(fsa, ft);
        decomp.add(fi, ComponentType.Irregular, ComponentInformation.Forecast);
        TsData fie = model.getSeries(ComponentType.Irregular, ComponentInformation.StdevForecast);
        if (fie != null) {
            decomp.add(fie, ComponentType.Irregular, ComponentInformation.StdevForecast);
        }
        return decomp;
    }

    private DefaultSeriesDecomposition correctLogs(ISeriesDecomposition model) {
        TsData ft;
        TsData fs;
        double ibias;
        double sbias;
        TsData y = model.getSeries(ComponentType.Series, ComponentInformation.Value);
        if (y == null) {
            return null;
        }
        y = y.exp();
        DefaultSeriesDecomposition decomp = new DefaultSeriesDecomposition(DecompositionMode.Multiplicative);
        decomp.add(y, ComponentType.Series);
        int n = y.getLength();
        int freq = y.getFrequency().intValue();
        int ny = n - n % freq;
        TsData s = model.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
        if (s != null) {
            s = s.exp();
            sbias = this.bias(s, ny);
            s.apply(x -> x / sbias);
            decomp.add(s, ComponentType.Seasonal);
            TsData se = model.getSeries(ComponentType.Seasonal, ComponentInformation.Stdev);
            if (se != null) {
                decomp.add(this.correctStdevForLog(se, s), ComponentType.Seasonal, ComponentInformation.Stdev);
            }
        } else {
            sbias = 1.0;
        }
        TsData i = model.getSeries(ComponentType.Irregular, ComponentInformation.Value);
        if (i != null) {
            i = i.exp();
            ibias = this.bias(i, i.getLength());
            i.apply(x -> x / ibias);
            TsData ie = model.getSeries(ComponentType.Irregular, ComponentInformation.Stdev);
            if (ie != null) {
                decomp.add(this.correctStdevForLog(ie, i), ComponentType.Irregular, ComponentInformation.Stdev);
            }
        } else {
            ibias = 1.0;
        }
        TsData t = model.getSeries(ComponentType.Trend, ComponentInformation.Value);
        if (t != null) {
            t = t.exp();
            t.apply(x -> x * sbias * ibias);
            decomp.add(t, ComponentType.Trend);
            TsData te = model.getSeries(ComponentType.Trend, ComponentInformation.Stdev);
            if (te != null) {
                decomp.add(this.correctStdevForLog(te, t), ComponentType.Trend, ComponentInformation.Stdev);
            }
        }
        TsData sa = TsData.divide(y, s);
        decomp.add(sa, ComponentType.SeasonallyAdjusted);
        TsData sae = model.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
        if (sae != null) {
            decomp.add(this.correctStdevForLog(sae, sa), ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
        }
        i = TsData.divide(sa, t);
        decomp.add(i, ComponentType.Irregular);
        TsData fy = model.getSeries(ComponentType.Series, ComponentInformation.Forecast);
        if (fy != null) {
            fy = fy.exp();
            decomp.add(fy, ComponentType.Series, ComponentInformation.Forecast);
        }
        if ((fs = model.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast)) != null) {
            fs = fs.exp();
            fs.apply(x -> x / sbias);
            decomp.add(fs, ComponentType.Seasonal, ComponentInformation.Forecast);
            TsData fse = model.getSeries(ComponentType.Seasonal, ComponentInformation.StdevForecast);
            if (fse != null) {
                decomp.add(this.correctStdevForLog(fse, fs), ComponentType.Seasonal, ComponentInformation.StdevForecast);
            }
        }
        if ((ft = model.getSeries(ComponentType.Trend, ComponentInformation.Forecast)) != null) {
            ft = ft.exp();
            ft.apply(x -> x * sbias * ibias);
            decomp.add(ft, ComponentType.Trend, ComponentInformation.Forecast);
            TsData fte = model.getSeries(ComponentType.Trend, ComponentInformation.StdevForecast);
            if (fte != null) {
                decomp.add(this.correctStdevForLog(fte, ft), ComponentType.Trend, ComponentInformation.StdevForecast);
            }
        }
        TsData fsa = TsData.divide(fy, fs);
        decomp.add(fsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
        TsData fsae = model.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
        if (fsae != null) {
            decomp.add(this.correctStdevForLog(fsae, fsa), ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
        }
        TsData fi = TsData.divide(fsa, ft);
        decomp.add(fi, ComponentType.Irregular, ComponentInformation.Forecast);
        TsData fie = model.getSeries(ComponentType.Irregular, ComponentInformation.StdevForecast);
        if (fie != null) {
            decomp.add(this.correctStdevForLog(fie, fi), ComponentType.Irregular, ComponentInformation.StdevForecast);
        }
        return decomp;
    }
}

