## ----include=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

knitr::opts_chunk$set(eval = TRUE, message = FALSE, results = 'asis', comment='')
options(width = 200)


## ----load-data----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(ProAE)
require(knitr)

data(tox_acute)


## ----results='markup'---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

acute <- tox_acute

str(acute)
  

## ----warnings=FALSE,results='markup'------------------------------------------------------------------------------------------------------------------------------------------------------------------

AUC = toxAUC(dsn = acute,
             id_var = "id",
             cycle_var = "Cycle",
             arm_var = "arm",
             baseline_val = 1,
             permute_tests = TRUE)



## ----fig.width=9,fig.height=4-------------------------------------------------------------------------------------------------------------------------------------------------------------------------

AUC[[3]][2]


