### Name: knnB
### Title: An interface to various machine learning methods for exprSets
### Aliases: allClass stat.diag.daB
###   stat.diag.daB,exprSet,character,integer-method cvB knn1B knnP lcaB
###   logitboostB lvq2B lvq3B olvq1B predLabels RObject knnB nnetB lvq1B
###   naiveBayesB svmB baggingB ipredknnB sldaB ldaB qdaB pamrB rpartB
###   randomForestB gbmB allClass,classifOutput-method
###   cvB,exprSet,character-method predLabels,MLOutput-method
###   predLabels,classifOutput-method last.warning distMat,MLOutput-method
###   RObject,MLOutput-method trainInds,classifOutput-method
###   xval,exprSet,character,nonstandardGeneric,character,missing-method
###   show,probMat-method show,probArray-method show,membMat-method
###   show,qualScore-method show,silhouetteVec-method show,MLOutput-method
###   baggingB,exprSet,character,integer-method
###   gbmB,exprSet,character,integer-method
###   ipredknnB,exprSet,character,integer-method
###   knn1B,exprSet,character,integer-method
###   knnB,exprSet,character,integer-method lcaB,exprSet,numeric-method
###   ldaB,exprSet,character,integer-method
###   logitboostB,exprSet,character,integer,numeric-method
###   lvq1B,exprSet,character,integer-method
###   lvq2B,exprSet,character,integer-method
###   lvq3B,exprSet,character,integer-method
###   naiveBayesB,exprSet,character,integer-method
###   nnetB,exprSet,character,integer-method
###   olvq1B,exprSet,character,integer-method
###   pamrB,exprSet,character,integer-method
###   qdaB,exprSet,character,integer-method
###   randomForestB,exprSet,character,integer-method
###   rpartB,exprSet,character,integer-method
###   sldaB,exprSet,character,integer-method
###   svmB,exprSet,character,integer-method
### Keywords: classif

### ** Examples

# access and trim an exprSet
library(golubEsets)
data(golubMerge)
smallG <- golubMerge[1:60,]
# set a PRNG seed for reproducibilitiy
set.seed(1234) # needed for nnet initialization
# now run the classifiers
knnB( smallG, "ALL.AML", 1:40 )
nnetB( smallG, "ALL.AML", 1:40, size=5, decay=.01 )
lvq1B( smallG, "ALL.AML", 1:40 )
naiveBayesB( smallG, "ALL.AML", 1:40 )
svmB( smallG, "ALL.AML", 1:40 )
baggingB( smallG, "ALL.AML", 1:40 )
ipredknnB( smallG, "ALL.AML", 1:40 )
sldaB( smallG, "ALL.AML", 1:40 )
ldaB( smallG, "ALL.AML", 1:40 )
qdaB( smallG[1:10,], "ALL.AML", 1:40 )
pamrB( smallG, "ALL.AML", 1:40 )
rpartB( smallG, "ALL.AML", 1:35 )
randomForestB( smallG, "ALL.AML", 1:35 )
gbmB( smallG, "ALL.AML", 1:40, n.minobsinnode=3 , n.trees=6000)
if (require(LogitBoost)) logitboostB( smallG, "ALL.AML", 1:40, 200 ) # summarize won't work with polych
stat.diag.daB( smallG, "ALL.AML", 1:40 )
#
# illustrate the xval method
#
LOO1 <- xval(smallG, "ALL.AML", knnB, "LOO" ) # same as knn.cv
LOO2 <- xval(smallG, "ALL.AML", knnB, "FUN", 0:0, function(x,y,i) {
  (1:ncol(exprs(x)))[-i] }, niter=72 )
table(LOO1, LOO2)



