yaqc.plot              package:yaqcaffy              R Documentation

_P_l_o_t_s _a _Y_A_Q_C_S_t_a_t_s _o_b_j_e_c_t

_D_e_s_c_r_i_p_t_i_o_n:

     Generates a visual summary of the various Affymetrix QC
     statistics.

_U_s_a_g_e:

     yaqc.plot(YAQCStatsObject, which,...)

_A_r_g_u_m_e_n_t_s:

YAQCStatsObject: an object of class '"YAQCStats"'.

   which: which quality metrics should be plotted (all by default).

     ...: other arguments.

_D_e_t_a_i_l_s:

     The quality control metrics of the 'YAQCStatsObject' are plotted 
     in a serie of graphs with the recommended ranges. 

     The scale factors are represented through a dot chart and the
     upper and lower limits are defined with vertical red lines. The
     other qc metircs are shown using dot plots. For the upper row box 
     plots (average background, average noise, percent present and 
     beta-actin and GAPDH ratios, the mean is represented by a dashed 
     red line and the mean +/- 2 stdev by red dotted lines. For the
     lower box  plots, featuring the internal controls, grey boxes
     defines the mean  (middle segment) +/- 2 stdev.

     Individual plots can also be generated with the 'which' argument:
     'sfs' for the scale factor, 'avbg' and 'avns' for the average
     background and noise, 'pp' for the percentage of present calls,
     'gapdh' and 'actin' for the GAPDH and beta-actin ratios, 'bio' for
     the hybridization controls and 'spikes' for the retro-transciption
     spiked controls. 

     If the YAQCStatsObject has been generated with an Expression Set
     objects,  the scale factors, average noise and background and
     percent present can not be computed and the respective plots are
     removed from the final graph.

_A_u_t_h_o_r(_s):

     Laurent Gatto

_E_x_a_m_p_l_e_s:

       ## load data
       library(affydata)
       data(Dilution)
       ## create the yaqc object
       ## and plot it
       qobj <- yaqc(Dilution)
       plot(qobj)

