### Name: topGOdata-class
### Title: Class "topGOdata"
### Aliases: topGOdata-class allGenes attrInTerm countGenesInTerm
###   description<- description feasible<- feasible geneSelectionFun<-
###   geneSelectionFun genes genesInTerm genTable GenTable graph<- graph
###   numGenes ontology<- ontology sigGenes numSigGenes termStat
###   updateGenes updateTerm<- usedGO expressionMatrix phenotype
###   expressionMatrix,topGOdata-method phenotype,topGOdata-method
###   geneScore geneScore,topGOdata,missing-method
###   geneScore,topGOdata,character-method scoresInTerm
###   scoresInTerm,topGOdata,missing-method
###   scoresInTerm,topGOdata,character-method show,topGOdata-method
###   allGenes,topGOdata-method
###   attrInTerm,topGOdata,character,character-method
###   attrInTerm,topGOdata,character,missing-method
###   countGenesInTerm,topGOdata,character-method
###   countGenesInTerm,topGOdata,missing-method
###   description<-,topGOdata,ANY-method description,topGOdata-method
###   feasible<-,topGOdata-method feasible,topGOdata-method
###   geneScore,topGOdata-method geneSelectionFun<-,topGOdata-method
###   geneSelectionFun,topGOdata-method genes,topGOdata-method
###   genesInTerm,topGOdata,character-method
###   genesInTerm,topGOdata,missing-method genTable,topGOdata,list-method
###   GenTable,topGOdata-method graph<-,topGOdata-method
###   graph,topGOdata-method initialize,topGOdata-method
###   numGenes,topGOdata-method ontology<-,topGOdata-method
###   ontology,topGOdata-method print,topGOdata-method
###   sigGenes,topGOdata-method numSigGenes,topGOdata-method
###   termStat,topGOdata,character-method termStat,topGOdata,missing-method
###   updateGenes,topGOdata,numeric,function-method
###   updateGenes,topGOdata,factor,missing-method
###   updateTerm<-,topGOdata,character-method usedGO,topGOdata-method
### Keywords: graphs classes

### ** Examples

## load the ALL dataset and the annotation library
library(ALL); data(ALL)
affyLib <- paste(annotation(ALL), "db", sep = ".")
library(package = affyLib, character.only = TRUE)

library(genefilter)
f1 <- pOverA(0.25, log2(100))
f2 <- function(x) (IQR(x) > 0.5)
ff <- filterfun(f1, f2)
ALL <- ALL[genefilter(ALL, ff), ]

## obtain the list of differentially expressed genes
## discriminate B-cell from T-cell
classLabel <- as.integer(sapply(ALL$BT, function(x) return(substr(x, 1, 1) == 'T')))

## over-expressed genes for T-cell samples
geneList <- getPvalues(exprs(ALL), classlabel = classLabel)

## the distribution of the adjusted p-values
hist(geneList, 100)
hist(geneList[geneList < 1], 100)

## define a function to select the "significant" genes
topDiffGenes <- function(allScore) {
  return(allScore < 0.01)
}

## how many differentially expressed genes are:
sum(topDiffGenes(geneList))

## build the topGOdata class 
GOdata <- new("topGOdata",
              ontology = "BP",
              allGenes = geneList,
              geneSel = topDiffGenes,
              description = "GO analysis of ALL data: Differential Expression between B-cell and T-cell",
              annot = annFUN.db,
              affyLib = affyLib)

## display the GOdata object
GOdata

##########################################################
## Examples on how to use the methods

## description of the experiment
description(GOdata)

## obtain the genes that will be used in the analysis
a <- genes(GOdata)
str(a)
numGenes(GOdata)

## obtain the score (p-value) of the genes
selGenes <- names(geneList)[sample(1:length(geneList), 10)]
gs <- geneScore(GOdata, whichGenes = selGenes)
print(gs)

## if we want an unnamed vector containing all the feasible genes
gs <- geneScore(GOdata, use.names = FALSE)
str(gs)

## the list of significant genes
sg <- sigGenes(GOdata)
str(sg)
numSigGenes(GOdata)

## to update the gene list 
.geneList <- geneScore(GOdata, use.names = TRUE)
GOdata ## more available genes
GOdata <- updateGenes(GOdata, .geneList, topDiffGenes)
GOdata ## the available genes are now the feasible genes

## the available GO terms (all the nodes in the graph)
go <- usedGO(GOdata)
length(go)

## to list the genes annotated to a set of specified GO terms
sel.terms <- sample(go, 10)
ann.genes <- genesInTerm(GOdata, sel.terms)
str(ann.genes)

## the score for these genes
ann.score <- scoresInTerm(GOdata, sel.terms)
str(ann.score)

## to see the number of annotated genes
num.ann.genes <- countGenesInTerm(GOdata)
str(num.ann.genes)

## to summarise the statistics
termStat(GOdata, sel.terms)



