### Name: getPvalues
### Title: Function to compute p-values of a t-test for a gene expression
###   matrix.
### Aliases: getPvalues
### Keywords: graphs

### ** Examples


library(ALL)
data(ALL)

## discriminate B-cell from T-cell
classLabel <- as.integer(sapply(ALL$BT, function(x) return(substr(x, 1, 1) == 'T')))

## Differentially expressed genes
geneList <- getPvalues(exprs(ALL), classlabel = classLabel,
                       alternative = "greater", correction = "BY")

hist(geneList, 50)



