### Name: annFUN
### Title: functions to map gene IDs to GO terms
### Aliases: annFUN.db annFUN annFUN.GO2genes annFUN.gene2GO annFUN.file
###   annFUN.org inverseList readMappings
### Keywords: misc

### ** Examples


library(hgu133a.db)
set.seed(111)

## generate a gene list and the GO annotations
numGenes <- 50
selGenes <- sample(ls(hgu133aGO), numGenes)
gene2GO <- lapply(mget(selGenes, envir = hgu133aGO), names)
gene2GO[sapply(gene2GO, is.null)] <- NA

## the annotation for the first three genes
gene2GO[1:3]

## inverting the annotations
go2genes <- annFUN.gene2GO(whichOnto = "CC", gene2GO = gene2GO)


## generate a GO list with the genes annotations
numGO <- 30
selGO <- sample(ls(hgu133aGO2PROBE), numGO)
GO2gene <- lapply(mget(selGO, envir = hgu133aGO2PROBE), as.character)

GO2gene[1:3]

## select only the GO terms for a specific ontology
go2gene <- annFUN.GO2genes(whichOnto = "CC", GO2gene = GO2gene)




