###################################################
### chunk number 1: 
###################################################
options(width = 95)


###################################################
### chunk number 2: 
###################################################
library(topGO)
library(ALL)
data(ALL)
data(geneList)


###################################################
### chunk number 3: 
###################################################
affyLib <- paste(annotation(ALL), "db", sep = ".")
library(package = affyLib, character.only = TRUE)


###################################################
### chunk number 4: 
###################################################
sum(topDiffGenes(geneList))


###################################################
### chunk number 5: 
###################################################
sampleGOdata <- new("topGOdata", 
                    description = "Simple session", ontology = "BP",
                    allGenes = geneList, geneSel = topDiffGenes,
                    nodeSize = 10,
                    annot = annFUN.db, affyLib = affyLib)


###################################################
### chunk number 6: 
###################################################
sampleGOdata


###################################################
### chunk number 7: 
###################################################
resultFisher <- runTest(sampleGOdata, algorithm = "classic", statistic = "fisher")


###################################################
### chunk number 8: 
###################################################
resultFisher


###################################################
### chunk number 9: 
###################################################
resultKS <- runTest(sampleGOdata, algorithm = "classic", statistic = "ks")
resultKS.elim <- runTest(sampleGOdata, algorithm = "elim", statistic = "ks")


###################################################
### chunk number 10: 
###################################################
allRes <- GenTable(sampleGOdata, classicFisher = resultFisher, 
                   classicKS = resultKS, elimKS = resultKS.elim,
                   orderBy = "elimKS", ranksOf = "classicFisher", topNodes = 10)


###################################################
### chunk number 11: 
###################################################
if(require(xtable))
  print(xtable(apply(allRes, 2, as.character)), floating = FALSE)


###################################################
### chunk number 12: 
###################################################
pValue.classic <- score(resultKS)
pValue.elim <- score(resultKS.elim)[names(pValue.classic)]
plot(pValue.classic, pValue.elim, xlab = "p-value classic", ylab = "p-value elim", cex = .5)


###################################################
### chunk number 13:  eval=FALSE
###################################################
## showSigOfNodes(sampleGOdata, score(resultKS.elim), firstTerms = 5, useInfo = 'all')


###################################################
### chunk number 14: 
###################################################
printGraph(sampleGOdata, resultKS.elim, firstSigNodes = 5, fn.prefix = "tGO", useInfo = "all", pdfSW = TRUE)


###################################################
### chunk number 15: 
###################################################
toLatex(sessionInfo())


