### Name: stam.cv
### Title: Cross Validated Training for StAM
### Aliases: stam.cv
### Keywords: classif

### ** Examples

## Not run: 
##D # load and prepare some data
##D library(golubEsets)
##D data(Golub_Merge)
##D golubTrain <- Golub_Merge[,1:38]
##D 
##D # classify into ALL and AML
##D # (root is chosen to yield results reasonably fast, 
##D #  consider GO:0008150 (biological process) to obtain 
##D #  meaningful results)
##D golubTrain.cv <- stam.cv(golubTrain, "ALL.AML", chip="hu6800",
##D                          root="GO:0005576", ndeltas=10)
##D 
##D # get further information
##D print(golubTrain.cv)
##D plot(golubTrain.cv, delta=0.6)
## End(Not run)



