###################################################
### chunk number 1: init
###################################################
require(snpMatrix)
require(hexbin)
data(for.exercise)


###################################################
### chunk number 2: 
###################################################
show(snps.10)


###################################################
### chunk number 3: 
###################################################
summary(snp.support)


###################################################
### chunk number 4: 
###################################################
summary(subject.support)


###################################################
### chunk number 5: 
###################################################
summary(snps.10)


###################################################
### chunk number 6: 
###################################################
snpsum <- col.summary(snps.10)
summary(snpsum)


###################################################
### chunk number 7: plot-snpsum
###################################################
par(mfrow = c(1, 2))
hist(snpsum$MAF)
hist(snpsum$z.HWE)


###################################################
### chunk number 8: sample-qc
###################################################
sample.qc <- row.summary(snps.10)
summary(sample.qc)


###################################################
### chunk number 9: plot-outliners-qc
###################################################
par(mfrow = c(1, 1))
plot(sample.qc)


###################################################
### chunk number 10: outliers
###################################################
use <- sample.qc$Heterozygosity>0
snps.10 <- snps.10[use, ]
subject.support <- subject.support[use, ]


###################################################
### chunk number 11: if-case-control
###################################################
if.case <- subject.support$cc == 1
if.control <- subject.support$cc == 0


###################################################
### chunk number 12: sum-case-control
###################################################
sum.cases <- col.summary(snps.10[if.case, ])
sum.controls <- col.summary(snps.10[if.control, ])


###################################################
### chunk number 13: plot-summaries
###################################################
hb <- hexbin(sum.controls$Call.rate, sum.cases$Call.rate, xbin=50)
sp <- plot(hb)
hexVP.abline(sp$plot.vp, 0, 1, col="black")


###################################################
### chunk number 14: plot-freqs
###################################################
sp <- plot(hexbin(sum.controls$MAF, sum.cases$MAF, xbin=50))
hexVP.abline(sp$plot.vp, 0, 1, col="white")


###################################################
### chunk number 15: tests
###################################################
tests <- single.snp.tests(cc, data = subject.support, snp.data = snps.10)


###################################################
### chunk number 16: sum-tests
###################################################
summary(tests)


###################################################
### chunk number 17: use
###################################################
use <- snpsum$MAF > 0.01 & snpsum$z.HWE^2 < 200


###################################################
### chunk number 18: sum-use
###################################################
sum(use)


###################################################
### chunk number 19: subset-tests
###################################################
tests <- tests[use]
position <- snp.support[use, "position"]


###################################################
### chunk number 20: plot-tests
###################################################
p1 <- p.value(tests, df=1)
plot(hexbin(position, -log10(p1), xbin=50))


###################################################
### chunk number 21: qqplot
###################################################
chi2 <- chi.squared(tests, df=1)
qq.chisq(chi2,  df = 1)


###################################################
### chunk number 22: more-tests
###################################################
tests <- single.snp.tests(cc, stratum, data = subject.support,
     snp.data = snps.10)
tests <- tests[use]
p1 <- p.value(tests, df = 1)
plot(hexbin(position, -log10(p1), xbin=50))


###################################################
### chunk number 23: more-tests-qq
###################################################
chi2 <- chi.squared(tests, df=1)
qq.chisq(chi2, df = 1)


###################################################
### chunk number 24: ord
###################################################
ord <- order(p1)
top10 <- ord[1:10]
top10


###################################################
### chunk number 25: top-10
###################################################
names <- tests@snp.names
p1[top10]
names[top10]
position[top10]


###################################################
### chunk number 26: top10-local
###################################################
posord <- order(position)
position <- position[posord]
names <- names[posord]
local <- names[position > 9.6e+07 & position < 9.8e+07]


###################################################
### chunk number 27: ld-2mb
###################################################
snps.2mb <- snps.10[, local]
ld.2mb <- ld.snp(snps.2mb)


###################################################
### chunk number 28: top1
###################################################
cc <- subject.support$cc
stratum <- subject.support$stratum
top <- as(snps.10[, "rs870041"], "numeric")
glm(cc ~ top + stratum, family = "binomial")


###################################################
### chunk number 29: top2
###################################################
top2 <- as(snps.10[, "rs10882596"], "numeric")
glm(cc ~ top2 + stratum, family = "binomial")


###################################################
### chunk number 30: blocks
###################################################
blocks <- split(posord, cut(position, seq(100000, 135300000, 20000)))
bsize <- sapply(blocks, length)
table(bsize)
blocks <- blocks[bsize>0]  


###################################################
### chunk number 31: twentyfive
###################################################
posord[1:20]
blocks[1:5]


###################################################
### chunk number 32: blocks-use
###################################################
snps.use <- snps.10[, use]
remove(snps.10)


###################################################
### chunk number 33: mtests
###################################################
mtests <- snp.rhs.tests(cc ~ stratum, family = "binomial", 
     data = subject.support, snp.data = snps.use, tests = blocks)
summary(mtests)


###################################################
### chunk number 34: plot-mtests
###################################################
pm <- p.value(mtests)
plot(hexbin(-log10(pm), xbin=50))


###################################################
### chunk number 35: qqplot-mtests
###################################################
qq.chisq(-2 * log(pm), df = 2)


