### Name: read.HapMap.data
### Title: function to import HapMap genotype data as snp.matrix
### Aliases: read.HapMap.data
### Keywords: manip IO file

### ** Examples

## Not run: 
##D 
##D ## ** Please be aware that the HapMap project generates new builds from
##D ## ** to time and the build number in the URL changes.
##D 
##D > library(snpMatrix)
##D > testurl <- "http://www.hapmap.org/genotypes/latest/fwd_strand/non-redundant/genotypes_chr1_CEU_r21_nr_fwd.txt.gz"
##D > result1 <- read.HapMap.data(testurl)
##D > sum1 <- summary(result1$snp.data)
##D 
##D > head(sum1[is.finite(sum1$z.HWE),], n=10)
##D            Calls Call.rate         MAF      P.AA       P.AB      P.BB      z.HWE
##D rs1933024     87 0.9666667 0.005747126 0.0000000 0.01149425 0.9885057 0.05391549
##D rs11497407    89 0.9888889 0.005617978 0.0000000 0.01123596 0.9887640 0.05329933
##D rs12565286    88 0.9777778 0.056818182 0.0000000 0.11363636 0.8863636 0.56511033
##D rs11804171    83 0.9222222 0.030120482 0.0000000 0.06024096 0.9397590 0.28293272
##D rs2977656     90 1.0000000 0.005555556 0.9888889 0.01111111 0.0000000 0.05299907
##D rs12138618    89 0.9888889 0.050561798 0.0000000 0.10112360 0.8988764 0.50240136
##D rs3094315     88 0.9777778 0.136363636 0.7272727 0.27272727 0.0000000 1.48118392
##D rs17160906    89 0.9888889 0.106741573 0.0000000 0.21348315 0.7865169 1.12733108
##D rs2519016     85 0.9444444 0.047058824 0.0000000 0.09411765 0.9058824 0.45528615
##D rs12562034    90 1.0000000 0.088888889 0.0000000 0.17777778 0.8222222 0.92554468
##D 
##D ## ** Please be aware that the HapMap project generates new builds from
##D ## ** to time and the build number in the URL changes.
##D 
##D ## This URL is broken up into two to fit the width of
##D ## the paper. There is no need in actual usage:
##D > testurl2 <- paste("http://www.hapmap.org/genotypes/latest/",
##D                   "fwd_strand/non-redundant/genotypes_chr1_JPT_r21_nr_fwd.txt.gz", sep="")
##D > result2 <- read.HapMap.data(testurl2)
##D 
##D > head(result2$snp.support)
##D            dbSNPalleles Assignment Chromosome Position Strand
##D rs10399749          C/T        C/T       chr1    45162      +
##D rs2949420           A/T        A/T       chr1    45257      +
##D rs4030303           A/G        A/G       chr1    72434      +
##D rs4030300           A/C        A/C       chr1    72515      +
##D rs3855952           A/G        A/G       chr1    77689      +
##D rs940550            C/T        C/T       chr1    78032      +
## End(Not run)



