### Name: ebam
### Title: Empirical Bayes Analysis of Microarrays
### Aliases: ebam
### Keywords: htest

### ** Examples
## Not run: 
##D   # Load the data of Golub et al. (1999) contained in the package multtest.
##D   data(golub)
##D   
##D   # golub.cl contains the class labels.
##D   golub.cl
##D   
##D   # Perform an EBAM analysis for the two class unpaired case assuming
##D   # unequal variances. Specify the fudge factor a0 by the suggested
##D   # choice of find.a0
##D   find.out <- find.a0(golub, golub.cl, rand = 123)
##D   ebam.out <- ebam(find.out)
##D   ebam.out
##D     
##D   # Since a0 = 0 leads to the largest number of genes (i.e. the suggested
##D   # choice of a0), the following leads to the same results as the above
##D   # analysis (but only if the random number generator, i.e. rand, is set
##D   # to the same number).
##D   ebam.out2 <- ebam(golub, golub.cl, a0 = 0, fast = TRUE, rand = 123)
##D   ebam.out2
##D 
##D   # If fast is set to TRUE in ebam, a crude estimate of the number of
##D   # falsely called genes is used (see the help file for z.ebam). This
##D   # estimate is always employed in find.a0. 
##D   # The exact number is used in ebam when performing
##D   ebam.out3 <- ebam(golub, golub.cl, a0 = 0, rand = 123)
##D   ebam.out3  
##D 
##D   # Since this is the recommended way, we use ebam.out3 at the end of
##D   # the Examples section for further analyses.
##D 
##D 
##D   # Perform an EBAM analysis for the two class unpaired case assuming
##D   # equal group variances. Set a0 = 0, and use B = 50 permutations
##D   # of the class labels.
##D   ebam.out4 <- ebam(golub, golub.cl, a0 = 0, var.equal = TRUE, B = 50,
##D      rand = 123)
##D   ebam.out4
##D     
##D   # Perform an EBAM analysis for the two class unpaired cased assuming
##D   # unequal group variances. Use the median (i.e. the 50% quantile)
##D   # of the standard deviations of the genes as fudge factor a0. And
##D   # obtain the number of genes and the FDR if a gene is called 
##D   # differentially when its posterior probability is larger than
##D   # 0.95.
##D   ebam.out5 <- ebam(golub, golub.cl, quan.a0 = 0.5, delta = 0.95,
##D      rand = 123)
##D   ebam.out5
##D     
##D   # For the third analysis, obtain the number of differentially
##D   # expressed genes and the FDR if a gene is called differentially
##D   # expressed if its posterior probability is larger than 0.8, 0.85,
##D   # 0.9, 0.95.
##D   print(ebam.out3, c(0.8, 0.85, 0.9, 0.95))
##D     
##D   # Generate a plot of the posterior probabilities for delta = 0.9.
##D   plot(ebam.out3, 0.9)
##D     
##D   # Obtain the list of genes called differentially expressed if their
##D   # posterior probability is larger than 0.99, and gene-specific 
##D   # statistics for these variables such as their z-value and their
##D   # local FDR.
##D   summary(ebam.out3, 0.99)
## End(Not run)


