###################################################
### chunk number 1: read
###################################################
library(rsbml)
doc <- rsbml_read(system.file("sbml", "GlycolysisLayout.xml", package = "rsbml"), dom = FALSE)


###################################################
### chunk number 2: dom
###################################################
dom <- rsbml_dom(doc)


###################################################
### chunk number 3: ids
###################################################
sapply(species(model(dom)), id)


###################################################
### chunk number 4: graph
###################################################
g <- rsbml_graph(doc)
graph::nodes(g)


###################################################
### chunk number 5: check
###################################################
rsbml_check(doc)


###################################################
### chunk number 6: problems
###################################################
tryCatch(rsbml_read("non-existent-file.xml"), 
         error = function(err) err$msg)


###################################################
### chunk number 7: xml
###################################################
xml <- rsbml_xml(doc)


