### Name: qpI2K
### Title: Random concentration matrix
### Aliases: qpI2K
### Keywords: models multivariate

### ** Examples

nVar <- 50 # number of variables
maxCon <- 5  # maximum connectivity per variable

I <- qpRndGraph(n.vtx=nVar, n.bd=maxCon)
K <- qpI2K(I)

realI <- K != 0
diag(realI) <- FALSE

sum(realI) / 2

sum(I) / 2

# all present edges (dependencies) in realI must be in I
identical(I & realI, realI)

# all missing edges (independencies) in I must be in realI
identical(!I & !realI, !I)




