### Name: calculateLimma
### Title: Calculate differential expression between conditions using limma
### Aliases: calculateLimma
### Keywords: manip

### ** Examples

if (require(affydata)) {
        data(Dilution)
        eset_rma <- rma(Dilution)
        #       Next line used so eset_rma only has information about the liver factor
        #       The scanner factor will thus be ignored, and the two arrays of each level
        #       of the liver factor will be treated as replicates
        pData(eset_rma) <- pData(eset_rma)[,1, drop=FALSE]
        limmaRes <- calculateLimma(eset_rma)
        topGeneIDs(limmaRes,numberOfGenes=6)
        plotErrorBars(eset_rma, topGenes(limmaRes))
}



