### Name: metahdep.FEMA
### Title: metahdep.FEMA
### Aliases: metahdep.FEMA
### Keywords: models htest

### ** Examples


###
### Example 1: gene expression data
### - this uses one gene from the HGU.prep.list object

# load data and extract components for meta-analysis (for one gene)
data(HGU.prep.list)
gene.data <- HGU.prep.list[[7]]
theta <- gene.data@theta
V <- gene.data@V
X <- gene.data@X
gene.name <- gene.data@gene

# fit a regular FEMA (no hierarchical dependence)
results <- metahdep.FEMA(theta, V, X, meta.name=gene.name, center.X=TRUE)
results

###
###  Example 2: glossing data
###  - this produces part of Table 5 in the Stevens and Taylor JEBS paper.

data(gloss)
FEMA <- metahdep.FEMA(gloss.theta, gloss.V, gloss.X, center.X=TRUE)
round(cbind( t(FEMA$beta.hats), t(FEMA$beta.hat.p.values)),4)




