### Name: tablesDE
### Title: Save HTML or CSV tables of differentially expressed genes
### Aliases: tablesDE
### Keywords: methods

### ** Examples

## Loading the dataset
data(gastro)

## Doing bootstrap from t statistic test fot 'Type' sample label, k=1000
## specifies one thousand bootstraps
gastro.ttest = deGenes2by2Ttest(gastro.summ, sLabelID="Type")

tablesDE(gastro.ttest) ## Save HTML tables

## To save only tables with p-value < 0.05
tablesDE(gastro.ttest, nDEgenes=0.05)

## To save only tables with 30 most significantly genes
tablesDE(gastro.ttest, nDEgenes=30)



