### Name: hierM
### Title: Function to do hierarchical cluster analysis
### Aliases: hierM
### Keywords: hplot

### ** Examples

## Loading the dataset
data(gastro)

## Doing a hierarchical cluster using all genes, for maigesRaw class
hierM(gastro.raw, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
      sLabelID="Sample", gLabelID="Name", doHeat=FALSE)

## Doing a hierarchical cluster using all genes, for maigesNorm class
hierM(gastro.norm, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
      sLabelID="Sample", gLabelID="Name", doHeat=FALSE)

## If you want to show the heatmap do
hierM(gastro.norm, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
      sLabelID="Sample", gLabelID="Name", doHeat=TRUE)

## If you want to show the hierarchical branch in both margins do
hierM(gastro.summ, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
      sLabelID="Sample", gLabelID="Name", doHeat=TRUE, group="B")

## If you want to use euclidean distance only into rows (spots or genes)
hierM(gastro.summ, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
      sLabelID="Sample", gLabelID="Name", doHeat=FALSE, group="R", distance="euclidean")



