### Name: getLabels
### Title: Method getLabels to pick gene and sample labels
### Aliases: getLabels.default getLabels.maigesDE getLabels.maigesDEcluster
###   getLabels.RGList getLabels.MAList getLabels.marrayRaw
###   getLabels.marrayNorm getLabels
### Keywords: array

### ** Examples

## Loading dataset
data(gastro)

## Getting the 'Tissue' label for samples in maigesRaw class object
getLabels(gastro.raw, "Tissue", sLabel=TRUE)

## Getting the 'Type' label for samples in maigesNorm class object
getLabels(gastro.summ, "Type", sLabel=TRUE)

## Getting the 'GeneName' label for genes (spots) in maigesRaw class object
getLabels(gastro.raw, "GeneName", sLabel=FALSE)

## Getting the 'Annot' label for samples in maigesNorm class object
getLabels(gastro.summ, "Annot", sLabel=FALSE)



