/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.experiment.datamatrix;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import java.io.File;
import org.systemsbiology.gaggle.experiment.datamatrix.MatrixProject;

public class MatrixPersister {
    private String dirPath = System.getProperty("user.home") + File.separator + ".dmv";
    private String dbFileName = this.dirPath + File.separator + "dmv-projects.yap";
    ObjectContainer database;

    public ObjectContainer getDatabase() {
        Db4o.configure().optimizeNativeQueries(true);
        File dir = new File(this.dirPath);
        if (!dir.exists()) {
            dir.mkdir();
        }
        this.database = Db4o.openFile((String)this.dbFileName);
        return this.database;
    }

    public boolean doesDatabaseExist() {
        File f = new File(this.dbFileName);
        return f.exists();
    }

    public void saveProject(MatrixProject project) {
        this.getDatabase().set((Object)project);
        this.closeDatabase();
    }

    public void closeDatabase() {
        if (this.database == null) {
            return;
        }
        this.database.close();
    }

    public MatrixProject getProjectByName(String name) {
        ObjectSet projects = this.getDatabase().query((Predicate)new FindByNameQuery(name));
        if (projects.size() == 0) {
            return null;
        }
        return (MatrixProject)projects.get(0);
    }

    public MatrixProject[] getAllProjects() {
        Query query = this.getDatabase().query();
        query.constrain(MatrixProject.class);
        query.descend("date").orderDescending();
        ObjectSet results = query.execute();
        return results.toArray(new MatrixProject[0]);
    }

    public static void main(String[] args) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FindByNameQuery
    extends Predicate<MatrixProject> {
        String name;

        public FindByNameQuery(String name) {
            this.name = name;
        }

        public boolean match(MatrixProject project) {
            return project.getName().equals(this.name);
        }
    }
}

