### Name: flowFlowJo-package
### Title: Turn FlowJo workspaces into flowCore compliant objects
### Aliases: flowFlowJo-package flowFlowJo


### ** Examples


# A demo set of FCS files and attendant FlowJo workspace are included with
# this package.  This extracts the info from the workspace.

library(flowFlowJo);
demoLocation <- system.file("extdata", "DemoWorkspace.wsp", package="flowFlowJo"); 
actualFCSLoc <- system.file("extdata/fcsFiles", package="flowFlowJo"); 
testList     <- readFlowJoList(demoLocation, altFileLocation=actualFCSLoc);
z            <- getFlowJoGates(testList, fileNamePatterns=c("C02"));

# Take a look at z.  It contains the name(s), location(s), compensation matrix, gate/filter(s) 
# and gate/filter names for one of the FCS files referenced in the workspace.




