### Name: filters
### Title: Filter vectors of Affymetrix Exon array probeset names according
###   to where they target
### Aliases: filters exonic intronic intergenic multitarget is.exonic
###   is.intronic is.intergenic is.multitarget select.probewise
###   exclude.probewise
### Keywords: misc

### ** Examples

  if(interactive()) {
    xmapConnect()
    gene <-  probeset.to.gene(c("3743919"))
    ps   <- gene.to.probeset(gene,as.vector=TRUE)
    exonic(ps)
    intronic(ps)
    intergenic(ps)
    multitarget(ps)
    exonic(ps,exclude=TRUE)
    intronic(ps,exclude=TRUE)
    intergenic(ps,exclude=TRUE)
    multitarget(ps,exclude=TRUE,mt.level=1)
    #or
    select.probewise(ps,"exonic") #etc..
    exclude.probewise(ps,"exonic") #etc..
    is.exonic(ps)
    is.intronic(ps)
    is.intergenic(ps)
    is.multitarget(ps)
    is.multitarget(ps,mt.level=4)

  }



