### Name: dyebias.monotonicityplot
### Title: Show the degree of monotonicity of the dye bias across the
###   slides.
### Aliases: dyebias.monotonicityplot
### Keywords: hplot misc

### ** Examples


  ## Don't show: 
     options(stringsAsFactors = FALSE)

     library(dyebias)
     library(dyebiasexamples)
     data(data.raw)
     data(data.norm)

     ### obtain estimate for the iGSDBs:
     iGSDBs.estimated <- dyebias.estimate.iGSDBs(data.norm,
                                                 is.balanced=TRUE,
                                                 verbose=FALSE)

     ### choose the estimators and which spots to correct:
     estimator.subset <- dyebias.umcu.proper.estimators(maInfo(maGnames(data.norm)))

     application.subset <- maW(data.norm) == 1 &
                   dyebias.application.subset(data.raw=data.raw, use.background=TRUE)

     ### do the correction:
     correction <- dyebias.apply.correction(data.norm=data.norm,
                                            iGSDBs = iGSDBs.estimated,
                                            estimator.subset=estimator.subset,
                                            application.subset = application.subset,
                                            verbose=FALSE)
  ## End Don't show                                     

  layout(matrix(1:2, nrow=1,ncol=2))

  order <- dyebias.monotonicityplot(data=data.norm, 
                        iGSDBs=iGSDBs.estimated, # from e.g. dyebias.estimate.iGSDBs
                        order=NULL,              # i.e., order by increasing slide bias
                        output=NULL,
                        main="before correction"
                        )

  order <- dyebias.monotonicityplot(data=correction$data.corrected,
                        iGSDBs=iGSDBs.estimated,
                        order=order,             # order by the original slide bias
                        output=NULL,
                        main="after correction"
                       ) 




