### Name: readPlateData
### Title: Read a collection of plate reader data files
### Aliases: readPlateData
### Keywords: manip

### ** Examples

    datadir <- system.file("KcViabSmall", package = "cellHTS")
    x <- readPlateData("Platelist.txt", "KcViabSmall", path=datadir)

    ## To read data files obtained from an EnVision plate reader:
    datadir <- system.file("EnVisionExample", package = "cellHTS")
    x <- readPlateData("platelist.txt", "EnVisionEx",
          importFun=getEnVisionRawData, path=datadir)

       ## to get the cross talk corrected data:
       y <- readPlateData("platelist.txt", "EnVisionEx", 
           importFun=getEnVisionCrosstalkCorrectedData, path=datadir)




