###################################################
### chunk number 1: setup1
###################################################
library("cellHTS2")


###################################################
### chunk number 2: setup2
###################################################
## for debugging:
options(error=recover)


###################################################
### chunk number 3: dataPath
###################################################
experimentName <- "TwoWayAssay"
dataPath <- system.file(experimentName, package="cellHTS2") 


###################################################
### chunk number 4: source import function
###################################################
source(file.path(dataPath, "importData.R"))


###################################################
### chunk number 5: readPlateData
###################################################
x <- readPlateList("Platelist.txt", name=experimentName,
                   importFun=importData, path=dataPath)


###################################################
### chunk number 6: showX
###################################################
x


###################################################
### chunk number 7: plateFileTable
###################################################
cellHTS2:::tableOutput(file.path(dataPath, "Platelist.txt"), selRows=1, 
  "plate list", preName="twoWay")


###################################################
### chunk number 8: configure the data
###################################################
x <- configure(x, descripFile = "Description.txt",
               confFile="Plateconf.txt", path=dataPath)


###################################################
### chunk number 9: well annottaion
###################################################
table(wellAnno(x))


###################################################
### chunk number 10: annotate the data
###################################################
x <- annotate(x, geneIDFile="GeneIDs.txt", path=dataPath)


###################################################
### chunk number 11: plateConfscreenLogTable
###################################################
cellHTS2:::tableOutputWithHeaderRows(file.path(dataPath, "Plateconf.txt"), 
                                     "plate configuration", selRows=NULL, preName="twoWay")


###################################################
### chunk number 12: geneIDsTable
###################################################
cellHTS2:::tableOutput(file.path(dataPath, "GeneIDs.txt"), "gene ID", 
                       selRows = 3:6, preName="twoWay")


###################################################
### chunk number 13: define controls
###################################################
negCtr <- "(?i)^GFP$|^mock$"
posCtr <- list(act = "(?i)^AATK$|^ATTK$", inh = "(?i)^MAP2K6$")


###################################################
### chunk number 14: writeReport1Show eval=FALSE
###################################################
## out <- writeReport(raw=x, outdir="2Wraw",
##                    posControls=posCtr, negControls=negCtr, 
##                    plotPlateArgs=list(xrange=c(300, 4000)))


###################################################
### chunk number 15: writeReport1Do
###################################################
out <- writeReport(raw=x, force=TRUE, outdir="2Wraw", 
                   posControls=posCtr, negControls=negCtr, 
                   plotPlateArgs=list(xrange=c(300, 4000)))


###################################################
### chunk number 16: browseReport1 eval=FALSE
###################################################
## browseURL(out)


###################################################
### chunk number 17: normalization
###################################################
xn <- normalizePlates(x, scale="multiplicative", log=TRUE, method ="negatives", 
                      varianceAdjust="none", negControls = negCtr)


###################################################
### chunk number 18: get the data as an array
###################################################
xnorm <- Data(xn)
dim(xnorm)


###################################################
### chunk number 19: score and summarize replicates
###################################################
xsc <- scoreReplicates(xn, sign="+", method="zscore") 
xsc <- summarizeReplicates(xsc, summary="mean") 


###################################################
### chunk number 20: boxplotzscore
###################################################
ylim <- quantile(Data(xsc), c(0.001, 0.999), na.rm=TRUE)
wa <- factor(as.character(wellAnno(xsc)), exclude="empty")   # to exclude "empty" wells
boxplot(Data(xsc) ~ wa, col="lightblue", main="scores", outline=FALSE, ylim=ylim, xaxt="n")
lab <- unique(plateConf(xsc)$Content)
lab <- lab[match(levels(wa), tolower(lab))]
axis(1, at=c(1:nlevels(wa)), labels=lab)


###################################################
### chunk number 21: report2Show eval=FALSE
###################################################
## out <- writeReport(raw=x, normalized=xn, scored=xsc, 
##                    outdir="2Wnormalized", posControls=posCtr, negControls=negCtr, 
##                    plotPlateArgs=list(xrange=c(-1,1)), imageScreenArgs=list(zrange=c(-2,3)))


###################################################
### chunk number 22: report2Do
###################################################
out <- writeReport(raw=x, normalized=xn, scored=xsc, 
                   outdir="2Wnormalized", posControls=posCtr, negControls=negCtr, 
                   plotPlateArgs=list(xrange=c(-1,1)), imageScreenArgs=list(zrange=c(-2,3)), 
                   force=TRUE)


###################################################
### chunk number 23: browse2 eval=FALSE
###################################################
## browseURL(out)


###################################################
### chunk number 24: savex
###################################################
save(xsc, file=paste(experimentName, ".rda", sep=""))


###################################################
### chunk number 25: sessionInfo
###################################################
toLatex(sessionInfo())


