###################################################
### chunk number 1: Ropts
###################################################
options(width=70)


###################################################
### chunk number 2: install eval=FALSE
###################################################
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("cellHTS2")


###################################################
### chunk number 3: setup1
###################################################
library("cellHTS2")


###################################################
### chunk number 4: dataPath
###################################################
experimentName <- "KcViab"
dataPath <- system.file(experimentName, package="cellHTS2") 


###################################################
### chunk number 5: dirDataPath
###################################################
dataPath
rev(dir(dataPath))[1:12]


###################################################
### chunk number 6: readPlateList
###################################################
x <- readPlateList("Platelist.txt", 
                   name=experimentName, 
                   path=dataPath)


###################################################
### chunk number 7: showX
###################################################
x


###################################################
### chunk number 8: plateFileTable
###################################################
cellHTS2:::tableOutput(file.path(dataPath, "Platelist.txt"), "plate list")
cellHTS2:::tableOutput(file.path(dataPath, names(intensityFiles(x))[1]), 
              "signal intensity", header=FALSE)


###################################################
### chunk number 9: see object state
###################################################
state(x)


###################################################
### chunk number 10: writeReport
###################################################
out <- writeReport(raw=x, force = TRUE, outdir = "report-raw")


###################################################
### chunk number 11: printout
###################################################
out


###################################################
### chunk number 12: browseReport1 eval=FALSE
###################################################
## browseURL(out)


###################################################
### chunk number 13: annotatePlateRes
###################################################
x <- configure(x,
               descripFile="Description.txt", 
               confFile="Plateconf.txt", 
               logFile="Screenlog.txt", 
               path=dataPath)


###################################################
### chunk number 14: plateConfscreenLogTable
###################################################
cellHTS2:::tableOutputWithHeaderRows(file.path(dataPath, "Plateconf.txt"), 
  "plate configuration", selRows=NULL)
cellHTS2:::tableOutput(file.path(dataPath, "Screenlog.txt"), 
  "screen log", selRows=1:3)


###################################################
### chunk number 15: 
###################################################
table(wellAnno(x))


###################################################
### chunk number 16: configurationplot
###################################################
png("cellhts2-configurationplot.png", width=324, height=324)
configurationAsScreenPlot(x)
dev.off()


###################################################
### chunk number 17: configurationplotShow eval=FALSE
###################################################
## configurationAsScreenPlot(x)


###################################################
### chunk number 18: normalizePlateMedian
###################################################
xn <- normalizePlates(x, 
                      scale="multiplicative", 
                      log=FALSE, 
                      method="median", 
                      varianceAdjust="none")


###################################################
### chunk number 19: compare cellHTs objects
###################################################
compare2cellHTS(x, xn)


###################################################
### chunk number 20: score replicates
###################################################
xsc <- scoreReplicates(xn, sign="-", method="zscore") 


###################################################
### chunk number 21: summarize replicates
###################################################
xsc <- summarizeReplicates(xsc, summary="mean") 


###################################################
### chunk number 22: boxplotzscore
###################################################
scores <- Data(xsc)
ylim <- quantile(scores, c(0.001, 0.999), na.rm=TRUE)
boxplot(scores ~ wellAnno(x), 
        col="lightblue", outline=FALSE, ylim=ylim)


###################################################
### chunk number 23: callvalues
###################################################
y <- scores2calls(xsc, z0=1.5, lambda=2)
png("cellhts2-callvalues.png")
plot(Data(xsc), Data(y), col="blue", pch=".",
     xlab="z-scores", ylab="calls", 
     main=expression(1/(1+e^{-lambda *(z-z[0])})))
dev.off()


###################################################
### chunk number 24: callvaluesShow eval=FALSE
###################################################
## y <- scores2calls(xsc, z0=1.5, lambda=2)
## plot(Data(xsc), Data(y), col="blue", pch=".",
##      xlab="z-scores", ylab="calls", 
##      main=expression(1/(1+e^{-lambda *(z-z[0])})))


###################################################
### chunk number 25: geneIDs
###################################################
xsc <- annotate(xsc, geneIDFile="GeneIDs_Dm_HFA_1.1.txt", 
                path=dataPath)


###################################################
### chunk number 26: geneIDsTable
###################################################
cellHTS2:::tableOutput(file.path(dataPath, "GeneIDs_Dm_HFA_1.1.txt"), 
     "gene ID", selRows = 3:6)


###################################################
### chunk number 27: printxagain
###################################################
xsc


###################################################
### chunk number 28: savex
###################################################
save(xsc, file=paste(experimentName, ".rda", sep=""))


###################################################
### chunk number 29: writeReport2
###################################################
out <- 
    writeReport(raw=x, normalized=xn, scored=xsc, 
                plotPlateArgs = TRUE, 
                imageScreenArgs = list(zrange=c(-4, 8), ar=1), 
                map=TRUE, force = TRUE, outdir = "report-normalized") 


###################################################
### chunk number 30: browseReport2 eval=FALSE
###################################################
## browseURL(out)


###################################################
### chunk number 31: imageScreen eval=FALSE
###################################################
## imageScreen(xsc, ar=1, zrange=c(-3,4))


###################################################
### chunk number 32: exportData eval=FALSE
###################################################
## writeTab(xsc, file="Scores.txt")


###################################################
### chunk number 33: exportOtherData eval=FALSE
###################################################
## # determine the ratio between each well and the plate median
## y <- array(as.numeric(NA), dim=dim(Data(x)))
## nrWell <- prod(pdim(x))
## nrPlate <- max(plate(x))
## for(p in 1:nrPlate) 
## {
##     j <- (1:nrWell)+nrWell*(p-1)
##     samples <- wellAnno(x)[j]=="sample"
##     y[j, , ] <- apply(Data(x)[j, , , drop=FALSE], 2:3, 
##                       function(w) w/median(w[samples], 
##                                            na.rm=TRUE)) 
## }
## 
## y+signif(y, 3)
## out <- y[,,1]
## out <- cbind(fData(xsc), out)
## names(out) <- c(names(fData(xsc)), 
## sprintf("Well/Median_r%d_ch%d", rep(1:dim(y)[2], dim(y)[3]), 
## rep(1:dim(y)[3], each=dim(y)[2])))
## write.tabdel(out, file="WellMedianRatio.txt")


###################################################
### chunk number 34: example for description file
###################################################
out <- templateDescriptionFile("template-Description.txt", 
                               force=TRUE)
out
readLines(out)


###################################################
### chunk number 35: old plateConfscreenLogTable
###################################################
cellHTS2:::tableOutput(file.path(dataPath, "old-Plateconf.txt"), 
  "cellHTS package-specific plate configuration", selRows=1:28)
cellHTS2:::tableOutput(file.path(dataPath, "old-Screenlog.txt"), 
  "cellHTS package-specific screen log", selRows=1:3)


###################################################
### chunk number 36: Z score method eval=FALSE
###################################################
##  xZ <- normalizePlates(x, scale="additive", log=FALSE, 
##          method="median", varianceAdjust="byPlate") 


###################################################
### chunk number 37: transfplots
###################################################
library("vsn")
png("cellhts2-transfplots.png", width=324, height=474)
par(mfcol=c(3,2))
myPlots=function(z,...) 
{
  hist(z[,1], 100, col="lightblue", xlab="",...)
  meanSdPlot(z, ylim=c(0, quantile(abs(z[,2]-z[,1]), 0.95, na.rm=TRUE)), ...)
  qqnorm(z[,1], pch='.', ...)
  qqline(z[,1], col='blue')
}
dv <- Data(xn)[,,1]
myPlots(dv, main="untransformed")
xlog <- normalizePlates(x, scale="multiplicative", log=TRUE, 
                        method="median", varianceAdjust="byExperiment")
dvlog <- Data(xlog)[,,1]
myPlots(dvlog, main="log2")
dev.off()


###################################################
### chunk number 38: transfplotsShow eval=FALSE
###################################################
## library("vsn")
## par(mfcol=c(3,2))
## myPlots=function(z,...) 
## {
##   hist(z[,1], 100, col="lightblue", xlab="",...)
##   meanSdPlot(z, ylim=c(0, quantile(abs(z[,2]-z[,1]), 0.95,
##                                    na.rm=TRUE)), ...)
##   qqnorm(z[,1], pch='.', ...)
##   qqline(z[,1], col='blue')
## }
## dv <- Data(xn)[,,1]
## myPlots(dv, main="untransformed")
## xlog <- normalizePlates(x, scale="multiplicative", log=TRUE, 
##        method="median", varianceAdjust="byExperiment")
## dvlog <- Data(xlog)[,,1]
## myPlots(dvlog, main="log2")


###################################################
### chunk number 39: sessionInfo
###################################################
toLatex(sessionInfo())


