### Name: summarizeChannels
### Title: Summarization of dual-channel data
### Aliases: summarizeChannels
### Keywords: manip

### ** Examples

    data(dualCh)
    x <- dualCh
    table(wellAnno(x))

    ## Define the controls for the different channels:
    negControls=vector("character", length=dim(Data(x))[3])

    ## channel 1 - gene A
    ## case-insensitive and match the empty string at the beginning and end of a line (to distinguish between "geneA" and "geneAB", for example, although this is not a problem for the well annotation in this example)

    negControls[1]= "(?i)^geneA$"  
    ## channel 2 - gene A and geneB
    negControls[2]= "(?i)^geneA$|^geneB$" 
    posControls = vector("character", length=dim(Data(x))[3])
    ## channel 1 - no controls
    ## channel 2 - geneC and geneD
    posControls[2]="(?i)^geneC$|^geneD$"
 ## Not run: 
##D     writeReport(cellHTSlist=list("raw"=x), map=TRUE, plotPlateArgs=TRUE, posControls=posControls, negControls=negControls)
##D  
## End(Not run)
    ## In this example, we first normalize each channel separately by 
    ## plate median scaling (no variance adjustment), since we need to make the measurements 
    ## comparable across plates for the next step of channel summarization:
        xn = normalizePlates(x, scale="multiplicative", log=FALSE, method="median", varianceAdjust="none") 
    ## Then, we define a low intensity threshold for the measurements in the constitutive channel R1, 
    ## which will be set to the 5
    ## and take the ratio R2/R1.
        xn = summarizeChannels(xn, fun = function(r1, r2, 
             thresh=quantile(r1, probs=0.05, na.rm=TRUE)) ifelse(r1>thresh, r2/r1, as.numeric(NA))) 
    ## After channel summarization, we take the log2 and apply plate median normalization, 
    ## and opt to not adjust the variance:
    xn = normalizePlates(xn, scale="multiplicative", log=TRUE, method="median", varianceAdjust="none") 
    ## Define the controls for the normalized and summarized intensities (only one channel):
    negControls = vector("character", length=dim(Data(xn))[3])
    ## For the single channel, the negative controls are geneA and geneB 
    negControls[1]= "(?i)^geneA$|^geneB$" 
    posControls = vector("character", length=dim(Data(xn))[3])
    ## For the single channel, the negative controls are geneC and geneD 
    posControls[1]="(?i)^geneC$|^geneD$"
 ## Not run: 
##D     writeReport(cellHTSlist=list("raw"=x, "normalized"=xn), force=TRUE, map=TRUE, plotPlateArgs=list(xrange=c(-3,3)), 
##D          posControls=posControls, negControls=negControls)
##D  
## End(Not run)

    ## Another option could be to just take the log2 of the ratio between R2 and R1 raw intensities:
    xn1 = summarizeChannels(x, fun = function(r1, r2) log2(r2/r1)) 




