### Name: scores2calls
### Title: Sigmoidal transformation of the score values stored in a cellHTS
###   object obtaining the call values for each probe.
### Aliases: scores2calls
### Keywords: manip

### ** Examples

    data(KcViabSmall)
    x <- normalizePlates(KcViabSmall, scale="multiplicative", method="median", varianceAdjust="none")
    x <- scoreReplicates(x, sign="-", method="zscore")
    x <- summarizeReplicates(x, summary="min")
    xc <- scores2calls(x, z0=1.5, lambda=2) 
    plot(Data(x), Data(xc), col="blue", xlab="z-scores", ylab="calls", main=expression(1/(1+e^{-lambda *(z-z[0])})))
    if(require(splots)) {
     sp = split(Data(xc), plate(xc))
     grid.newpage()
     plotScreen(sp, zrange=c(0,1), fill=c("white", "red"), na.fill="yellow",
               main="Calls", ncol=3L)
    }



