###################################################
### chunk number 1: 
###################################################
library(bgx)


###################################################
### chunk number 2: 
###################################################
library(affydata)
library(hgu95av2cdf)
data(Dilution)
eset <- bgx(Dilution, samplesets=c(2,2), probeAff=FALSE, burnin=2048, iter=8192,genes=c(12500:12599), output="all")


###################################################
### chunk number 3: 
###################################################
exprs(eset)[10:40,] # Shorthand for assayData(eset)\$exprs[10:40,]


###################################################
### chunk number 4: 
###################################################
sampleNames(Dilution)


###################################################
### chunk number 5: 
###################################################
bgxOutput <- readOutput.bgx("run.1")


###################################################
### chunk number 6: 
###################################################
plotExpressionDensity(bgxOutput, gene=10)


###################################################
### chunk number 7: 
###################################################
rankedGeneList <- rankByDE(bgxOutput)
print(rankedGeneList[1:25,]) # print top 25 DEG


###################################################
### chunk number 8: 
###################################################
unlink("run.1", recursive=TRUE)


