### Name: getGENETITLE
### Title: Find gene titles
### Aliases: getGENETITLE
### Keywords: manip

### ** Examples

##example Affymetrix annotation file and its location
annotationFile<-'HG-U133_Plus_2_annot_part.csv'
dataDirectory<-system.file('data',package='annotationTools')

##load annotation file
annotation<-read.csv(paste(dataDirectory,annotationFile,sep='/'),colClasses='character')

##get gene titles
myPS<-c('117_at','1007_s_at','1552288_at',NA,'xyz_at')
getGENETITLE(myPS,annotation)

##track origin of annotation failure for the 3 last probe set IDs
getGENETITLE(myPS,annotation,diagnose=TRUE)



