###################################################
### chunk number 1: set up
###################################################
library("SLGI")
library("org.Sc.sgd.db")

##loading Tong et al data
data(SGA)
data(Atong)


###################################################
### chunk number 2: rejected
###################################################
rejected <- length(intersect(SGA, org.Sc.sgdREJECTORF))


###################################################
### chunk number 3: aliasMatch
###################################################
updateSGA=mget(SGA, org.Sc.sgdCOMMON2ORF, ifnotfound = NA )


###################################################
### chunk number 4: essential genes in query gene list
###################################################
data(essglist)
esg = names(essglist)
n1 <- sum( esg %in% dimnames(Atong)[[1]])
n2 <- sum( esg %in% dimnames(Atong)[[2]])


###################################################
### chunk number 5: 
###################################################
data(Boeke2006raw)
data(Boeke2006)


###################################################
### chunk number 6: 
###################################################
## Schuldiner et al. (2005)
data(gi2005)
data(gi2005.metadata)


###################################################
### chunk number 7: 
###################################################
data(TFmat)


###################################################
### chunk number 8: ScISI
###################################################
library(ScISI)
data(ScISIC)
ScISIC[1:5, 1:5]


###################################################
### chunk number 9: 
###################################################
data(Boeke2006)
data(dSLAM)

dim(Boeke2006)
Boeke2006red <- gi2Interactome(Boeke2006, ScISIC)
dim(Boeke2006red)


###################################################
### chunk number 10: 
###################################################
interact <- getInteraction(Boeke2006red, dSLAM, ScISIC)


###################################################
### chunk number 11: 
###################################################
intSummary <- iSummary(interact$bwMat, n=5)


###################################################
### chunk number 12:  eval=FALSE
###################################################
## modelBoeke <- modelSLGI(Boeke2006red, 
##           universe= dSLAM, interactome=ScISIC,type="intM", perm=5)


###################################################
### chunk number 13:  eval=FALSE
###################################################
## plot(modelBoeke,pch=20)


###################################################
### chunk number 14:  eval=FALSE
###################################################
## array <- dSLAM[dSLAM %in% rownames(ScISIC)]
## query <- rownames(Boeke2006)[rownames(Boeke2006) %in% rownames(ScISIC)]
## allInteract <- matrix(1, nrow=length(query), ncol=length(array),
##                dimnames=list(query, array))
## tested <- getInteraction(allInteract, dSLAM, ScISIC)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## testedInteract <- test2Interact(iMat=interact$bwMat, tMat=tested$bwMat, interactome=ScISIC)
## significant <- hyperG(cbind("Tested"=testedInteract$tested,"Interact"=testedInteract$interact), 
##               sum(Boeke),  nrow(Boeke2006red)*length(dSLAM)) 


