###################################################
### chunk number 1: options
###################################################
options(continue="  ")


###################################################
### chunk number 2:  eval=FALSE
###################################################
## help(package="SIM")


###################################################
### chunk number 3: 
###################################################
library(SIM)


###################################################
### chunk number 4: 
###################################################
data(expr.data)
data(acgh.data)
data(samples)  


###################################################
### chunk number 5: 
###################################################
names(expr.data)
names(acgh.data)    


###################################################
### chunk number 6: 
###################################################
acgh.data.only <- acgh.data[, 5:ncol(acgh.data)] 
expr.data.only <- expr.data[, 5:ncol(expr.data)] 
acgh.data.s <- acgh.data.only[, order(colnames(acgh.data.only))] 
expr.data.s <- expr.data.only[, order(colnames(expr.data.only))] 
sum(colnames(expr.data.s) == colnames(acgh.data.s))
acgh.data <- cbind(acgh.data[, 1:4], acgh.data.s) 
expr.data <- cbind(expr.data[, 1:4], expr.data.s)  


###################################################
### chunk number 7: 
###################################################
assemble.data(dep.data = acgh.data, indep.data = expr.data, 
ann.dep = colnames(acgh.data)[1:4], 
ann.indep = colnames(expr.data)[1:4], 
dep.id = "ID", dep.chr = "CHROMOSOME", dep.pos = "STARTPOS", 
dep.symb = "Symbol", indep.id = "ID", indep.chr = "CHROMOSOME", 
indep.pos = "STARTPOS", indep.symb = "Symbol", 
overwrite = TRUE, run.name = "chr8q")


###################################################
### chunk number 8: 
###################################################
integrated.analysis(samples = samples, input.regions = 8, adjust = FALSE, zscores = TRUE, method = "auto", run.name = "chr8q")  


###################################################
### chunk number 9: 
###################################################
sim.plot.pvals.on.genome(input.regions = 8, adjust.method = "BY", run.name = "chr8q", pdf = TRUE) 


###################################################
### chunk number 10: 
###################################################
tabulate.pvals(input.regions = 8, adjust.method = "BY", bins = c(0.001, 0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.2, 1), significance.idx=8, order.by="\%", decreasing=TRUE, run.name = "chr8q")


###################################################
### chunk number 11: 
###################################################
sim.plot.pvals.on.region(input.regions = 8, adjust.method = "BY", run.name = "chr8q") 


###################################################
### chunk number 12: 
###################################################
sim.plot.zscore.heatmap(input.regions = 8, significance = 0.2, z.threshold = 3, show.names.dep = TRUE, show.names.indep = TRUE, adjust.method = c("BY"), scale = "auto", plot.method = "smooth", run.name = "chr8q", pdf=TRUE) 


###################################################
### chunk number 13: 
###################################################
tabulate.top.dep.features(input.regions = 8, adjust.method = "BY", run.name = "chr8q") 


###################################################
### chunk number 14: 
###################################################
tabulate.top.indep.features(input.regions = 8, adjust.method = "BY", run.name = "chr8q") 


###################################################
### chunk number 15: 
###################################################
toLatex(sessionInfo())


