### Name: tabulate.top.indep.features
### Title: Lists the mean z-scores for the independent features
### Aliases: tabulate.top.indep.features
### Keywords: misc

### ** Examples

#load the datasets and the samples to run the integrated analysis
data(expr.data)
data(acgh.data)
data(samples) 
         
#assemble the data
assemble.data(dep.data = acgh.data, indep.data = expr.data, ann.dep = colnames(acgh.data)[1:4], ann.indep = colnames(expr.data)[1:4], dep.id="ID", dep.chr = "CHROMOSOME",dep.pos = "STARTPOS",dep.symb="Symbol",indep.id="ID",indep.chr = "CHROMOSOME", indep.pos = "STARTPOS",indep.symb="Symbol", overwrite = TRUE,run.name = "chr8")

#run the integrated analysis
integrated.analysis(samples = samples, input.regions = 8, adjust=FALSE, zscores=TRUE, method = "auto", run.name="chr8")

#get the highest associated independent features
tabulate.top.indep.features(input.regions = 8, adjust.method="BY", significance=0.2,sort.order='positive', run.name = "chr8")



