### Name: fetchSignal
### Title: Fetch data from the GATC database
### Aliases: fetchSignal
### Keywords: database

### ** Examples

## Not run: 
##D # Do not run example 1. Fetch Probeset, Signal, ABS_CALL and CHIP for one sample.
##D library(RODBC)
##D (channel<-odbcConnect("DSN",uid="USERID",pwd="PASSWORD"))
##D ali.data <-fetchSignal(experiment="AZ33 ALI", channel, chip="hg_u95a")
##D  colnames(ali.data)
##D #[1] "FILENAME" "PROBESET" "SIGNAL" "ABS_CALL" "CHIP"
##D 
##D # Do not run example 2
##D t1 <- paste("select q1.name as name from experiment q1, physical_chip q2, chip_design q3")
##D t2 <- paste("where q1.physical_chip_id=q2.id and q3.id=q2.design_id and ")
##D t3 <- paste("upper(q1.name) like '
##D Ids <- sqlQuery(channel,paste(t1,t2,t3) )   
##D # fetch Signal from GATC corresponding to the U95A chip for all samples in experiment. #
##D tmp <- apply(Ids,1,toupper)
##D probes <- data.frame(fetchSignal(experiment=tmp[1],channel, chip="hg_u95a")[,"PROBESET"])
##D test <- matrix(nrow=nrow(as.data.frame(probes)),ncol=nrow(Ids))
##D for(i in 1:nrow(as.data.frame(tmp))){
##D    test[,i] <- fetchSignal(experiment=tmp[i],channel, chip="hg_u95a")[,"SIGNAL"]
##D }
##D codes <- data.frame(apply(Ids,1,code<-function(x) substr(x,1,5)))
##D colnames(test) <- as.character(t(codes))
##D test <- test[,order(colnames(test))]
## End(Not run)



