### Name: RtreemixSim-class
### Title: Class "RtreemixSim"
### Aliases: SamplingMode,RtreemixSim SamplingParam,RtreemixSim
###   SamplingTimes SimPatterns WaitingTimes getModel noDraws,RtreemixSim
###   noDraws RtreemixSim-class SamplingMode,RtreemixSim-method
###   SamplingParam,RtreemixSim-method SamplingTimes,RtreemixSim-method
###   SimPatterns,RtreemixSim-method WaitingTimes,RtreemixSim-method
###   getModel,RtreemixSim-method noDraws,RtreemixSim-method
###   initialize,RtreemixSim-method print,RtreemixSim-method
###   show,RtreemixSim-method
### Keywords: classes

### ** Examples

## Generate a random RtreemixModel object with 3 components and 9 genetic events.
rand.mod <- generate(K = 3, no.events = 9, noise.tree = TRUE, prob = c(0.2, 0.8))
show(rand.mod)

## Create an RtreemixSim object by simulating patterns with their sampling and waiting times from a given mixture model.
sim.data <- sim(model = rand.mod, sampling.mode = "exponential", sampling.param = 1, no.sim = 200)
show(sim.data)

## See the slots from the RtreemixSim object.
SimPatterns(sim.data)
SamplingMode(sim.data)
SamplingParam(sim.data)
WaitingTimes(sim.data)
SamplingTimes(sim.data)
## See model.
getModel(sim.data)
## See number of simulated patterns.
noDraws(sim.data)



