### Name: assessment-class
### Title: assessment: A central class to perform one and two layers of
###   external cross-validation on microarray data
### Aliases: assessment-class getClassifierName,assessment-method
###   getClassifierName<-,assessment-method getClassifierName
###   getClassifierName<- getFeatureSelectionMethod,assessment-method
###   getNoFolds1stLayer,assessment-method
###   getNoFolds1stLayer<-,assessment-method getNoFolds1stLayer
###   getNoFolds1stLayer<- getNoFolds2ndLayer,assessment-method
###   getNoFolds2ndLayer<-,assessment-method getNoFolds2ndLayer
###   getNoFolds2ndLayer<- getNoOfRepeats,assessment-method
###   getNoOfRepeats<-,assessment-method getNoOfRepeats getNoOfRepeats<-
###   getResult1LayerCV,assessment-method
###   getResult1LayerCV<-,assessment-method getResult1LayerCV
###   getResult1LayerCV<- getResult2LayerCV,assessment-method
###   getResult2LayerCV<-,assessment-method getResult2LayerCV
###   getResult2LayerCV<- getSvmKernel,assessment-method
###   getSvmKernel<-,assessment-method getSvmKernel getSvmKernel<-
###   getTypeFoldCreation,assessment-method
###   getTypeFoldCreation<-,assessment-method getTypeFoldCreation
###   getTypeFoldCreation<-
### Keywords: classes

### ** Examples

#dataPath <- file.path("C:", "Documents and Settings", "c.maumet", "My Documents", "Programmation", "data")
#myDataset <- new("dataset", dataId="vantVeer_70", dataPath=file.path(dataPath, "vantVeer_70"))
# myDataset<-loadData(myDataset)

data('vV70genesDataset')

# assessment with RFE and SVM
myExpe <- new("assessment", dataset=vV70genes,
                   noFolds1stLayer=10,
                   noFolds2ndLayer=9,
                   classifierName="svm",
                   typeFoldCreation="original",
                   svmKernel="linear",
                   noOfRepeat=2,
                   featureSelectionOptions=new("geneSubsets", optionValues=c(1,2,3,4,5,6)))

# Another assessment where the subsets are computed automatically
anotherExpe <- new("assessment",    dataset=vV70genes,
                                   noFolds1stLayer=10,
                                   noFolds2ndLayer=9,
                                   classifierName="svm",
                                   typeFoldCreation="original",
                                   svmKernel="linear",
                                   noOfRepeat=2)
getFeatureSelectionOptions(anotherExpe, topic='maxSubsetSize')
getFeatureSelectionOptions(anotherExpe, topic='subsetsSizes')

# assessment with NSC
expeWithNSC <- new("assessment",dataset=vV70genes,
                               noFolds1stLayer=10,
                               noFolds2ndLayer=9,
                               classifierName="nsc",
                               featureSelectionMethod='nsc',
                               typeFoldCreation="original",
                               svmKernel="linear",
                               noOfRepeat=2)
getFeatureSelectionOptions(expeWithNSC, topic='thresholds')



