dijkstra.sp               package:RBGL               R Documentation

_D_i_j_k_s_t_r_a'_s _s_h_o_r_t_e_s_t _p_a_t_h_s _u_s_i_n_g _b_o_o_s_t _C++

_D_e_s_c_r_i_p_t_i_o_n:

     dijkstra's shortest paths

_U_s_a_g_e:

     dijkstra.sp(g,start=nodes(g)[1], eW=unlist(edgeWeights(g)))

_A_r_g_u_m_e_n_t_s:

       g: instance of class graph 

   start: character: node name for start of path 

      eW: numeric: edge weights.  

_D_e_t_a_i_l_s:

     These functions are interfaces to the Boost graph library C++
     routines for Dijkstra's shortest paths.

     For some graph subclasses, computing the edge weights can be
     expensive. If you are calling 'dijkstra.sp' in a loop, you can
     pass the edge weights explicitly to avoid the edge weight creation
     cost.

_V_a_l_u_e:

     A list with elements: 

distance: The vector of distances from 'start' to each node of 'g';
          includes 'Inf' when there is no path from 'start'.

  penult: A vector of indices  (in 'nodes(g)') of predecessors
          corresponding to each node on the path from that node back to
          'start'

   start: The start node that was supplied in the call to
          'dijkstra.sp'.

_A_u_t_h_o_r(_s):

     VJ Carey <stvjc@channing.harvard.edu>

_R_e_f_e_r_e_n_c_e_s:

     Boost Graph Library ( www.boost.org/libs/graph/doc/index.html )

     The Boost Graph Library: User Guide and Reference Manual; by
     Jeremy G. Siek, Lie-Quan Lee, and Andrew Lumsdaine;
     (Addison-Wesley, Pearson Education Inc., 2002), xxiv+321pp. ISBN
     0-201-72914-8

_S_e_e _A_l_s_o:

     'bellman.ford.sp', 'dag.sp', 'johnson.all.pairs.sp', 'sp.between'

_E_x_a_m_p_l_e_s:

     con1 <- file(system.file("XML/dijkex.gxl",package="RBGL"), open="r")
     dd <- fromGXL(con1)
     close(con1)
     dijkstra.sp(dd)
     dijkstra.sp(dd,nodes(dd)[2])

     con2 <- file(system.file("XML/ospf.gxl",package="RBGL"), open="r")
     ospf <- fromGXL(con2)
     close(con2)
     dijkstra.sp(ospf,nodes(ospf)[6])

