### Name: pSeqBuilder_DB
### Title: Build Data Packages for Query Sequences
### Aliases: pSeqBuilder_DB


### ** Examples

## Set path, version and author for the package.
pkgPath <- tempdir()                                       
version <- "1.0.0"                                     
author <- list()                                       
author[["authors"]] <- "Hong Li"                       
author[["maintainer"]] <- "Hong Li <sysptm@gmail.com>"

## Set query sequences.
tmp = system.file("data", "query.example", package="PAnnBuilder")
tmp = readLines(tmp)
tag = grep("^>",tmp)
query <- sapply(1:(length(tag)-1), function(x){ 
     paste(tmp[(tag[x]+1):(tag[x+1]-1)], collapse="") })
query <- c(query, paste(tmp[(tag[length(tag)]+1):length(tmp)], collapse="") )
names(query) = sub(">","",tmp[tag])

## Set parameters for sequence similarity.
blast <- c("blastp", "10.0", "BLOSUM62", "0", "-1", "-1", "T", "F")
names(blast) <- c("p","e","M","W","G","E","U","F")
match <- c(0.00001, 0.95, 0.95)
names(match) <- c("e","c","i")
      
if(interactive()){
    ## Use packages "org.Hs.sp.db", "org.Hs.ipi.db" to produce annotation R
    ## package for query sequence. Packages "org.Hs.sp.db", "org.Hs.ipi.db"
    ## can be downloaded from http://www.biosino.org/PAnnBuilder/example.jsp. 
    annPkgs = c("org.Hs.sp.db","org.Hs.ipi.db")  
    seqName = c("org.Hs.spSEQ","org.Hs.ipiSEQ")  
    pSeqBuilder_DB(query, annPkgs, seqName, blast, match, 
    prefix="test1", pkgPath, version, author)    
}



