### Name: pBaseBuilder_DB
### Title: Build Data Packages for Primary Protein Database
### Aliases: pBaseBuilder_DB


### ** Examples

# Set path, version and author for the package.
pkgPath <- tempdir()
version <- "1.0.0"
author <- list()
author[["authors"]] <- "Hong Li"
author[["maintainer"]] <- "Hong Li <sysptm@gmail.com>"

## It may take a long time to parse database and build R package.
if(interactive()){
    # Build annotation data packages "org.Hs.sp.db" for Homo sapiens
    # proteins in SwissProt.
    pBaseBuilder_DB(baseMapType = "sp", organism = "Homo sapiens",  
                    prefix = "org.Hs.sp", pkgPath = pkgPath, version = version, 
                    author = author)                 
    
    # Build annotation data packages "org.Mm.ipi.db" for Mus musculus
    # proteins in IPI.
    pBaseBuilder_DB(baseMapType = "ipi", organism = "Mus musculus",  
                    prefix = "org.Mm.ipi", pkgPath = pkgPath, version = version, 
                    author = author)
                            
    # Build annotation data packages "org.Rn.ref.db" for Rattus norvegicus
    # proteins in NCBI RefSeq.
    pBaseBuilder_DB(baseMapType = "refseq", organism = "Rattus norvegicus",
                    prefix = "org.Rn.ref", pkgPath = pkgPath, version = version,
                    author = author)
}



