### Name: intBuilder_DB
### Title: Build Data Package for Interaction
### Aliases: intBuilder_DB


### ** Examples

# Set path, version and author for the package.
pkgPath <- tempdir()
version <- "1.0.0"
author <- list()
author[["authors"]] <- "Hong Li"
author[["maintainer"]] <- "Hong Li <sysptm@gmail.com>"

## It may take a long time to parse database and build R package.
if(interactive()){
    # Build annotation data package "int.geneint" for interaction data from NCBI.
    intBuilder_DB(src="geneint", 
    prefix="int.geneint", pkgPath, version, author) 
    
    # Build annotation data package "int.intact" for IntAct database.
    intBuilder_DB(src="intact", 
    prefix="int.intact", pkgPath, version, author) 
    
    # Build annotation data package "int.mppi" for interaction data from MIPS.
    intBuilder_DB(src="mppi", 
    prefix="int.mppi", pkgPath, version, author) 
    
    # Build annotation data package "int.did" for 3DID database.
    intBuilder_DB(src="3DID", 
    prefix="int.did", pkgPath, version, author) 
    
    # Build annotation data package "int.domine" for DOMINE database.
    intBuilder_DB(src="DOMINE", 
    prefix="int.domine", pkgPath, version, author) 
}



