###################################################
### chunk number 1: 
###################################################
library(KCsmart)


###################################################
### chunk number 2: 
###################################################
data(hsSampleData)


###################################################
### chunk number 3: 
###################################################
str(hsSampleData)


###################################################
### chunk number 4: 
###################################################
data(hsMirrorLocs)


###################################################
### chunk number 5: 
###################################################
spm1mb <- calcSpm(hsSampleData, hsMirrorLocs)
spm4mb <- calcSpm(hsSampleData, hsMirrorLocs, sigma=4000000)


###################################################
### chunk number 6: 
###################################################
plot(spm1mb)


###################################################
### chunk number 7: 
###################################################
plot(spm1mb, chromosomes=c(1, 12, "X"), type="g")


###################################################
### chunk number 8: 
###################################################
sigLevel1mb <- findSigLevelTrad(hsSampleData, spm1mb, n=10, p=0.05)


###################################################
### chunk number 9: 
###################################################
plot(spm1mb, sigLevels=sigLevel1mb, type=1)


###################################################
### chunk number 10: 
###################################################
plot(spm1mb, chromosomes=c(1, 12, "X"), type="g", sigLevels=sigLevel1mb)


###################################################
### chunk number 11: 
###################################################
sigRegions1mb <- getSigSegments(spm1mb,sigLevel1mb)


###################################################
### chunk number 12: 
###################################################
sigRegions1mb


###################################################
### chunk number 13: 
###################################################
sigRegions1mb@gains[[1]]$probes


###################################################
### chunk number 14: 
###################################################
sigLevel4mb <- findSigLevelTrad(hsSampleData, spm4mb, n=10)


###################################################
### chunk number 15: 
###################################################
plotScaleSpace(list(spm1mb, spm4mb), list(sigLevel1mb, sigLevel4mb), type='g')


###################################################
### chunk number 16: 
###################################################
spmc1mb <- calcSpmCollection(hsSampleData, hsMirrorLocs, cl=c(rep(0,10),rep(1,10)), sigma=1000000)


###################################################
### chunk number 17: 
###################################################
spmc1mb.sig <- compareSpmCollection(spmc1mb, nperms=3, method=c("siggenes"))
spmc1mb.sig


###################################################
### chunk number 18: 
###################################################
spmc1mb.sig.regions <- getSigRegionsCompKC(spmc1mb.sig)
spmc1mb.sig.regions


###################################################
### chunk number 19: 
###################################################
plot(spmc1mb.sig, sigRegions=spmc1mb.sig.regions)


