### Name: TypedList-class
### Title: Typed Lists
### Aliases: TypedList-class updateTypedList elementClass
###   elementClass,TypedList-method elementLengths
###   elementLengths,TypedList-method length,TypedList-method
###   names,TypedList-method names<-,TypedList-method [,TypedList-method
###   [<-,TypedList-method [[,TypedList-method [[<-,TypedList-method
###   $<-,TypedList-method append,TypedList,TypedList-method
###   c,TypedList-method as.list,TypedList-method
###   coerce,TypedList,list-method unlist,TypedList-method
###   lapply,TypedList-method sapply,TypedList-method show,TypedList-method
### Keywords: methods classes

### ** Examples

  ## demonstrated on IntegerList objects, as TypedList is virtual

  int1 <- c(1L,2L,3L,5L,2L,8L)
  int2 <- c(15L,45L,20L,1L,15L,100L,80L,5L)
  collection <- IntegerList(int1, int2)

  ## names
  names(collection) <- c("one", "two")
  names(collection)
  names(collection) <- NULL # clear names
  names(collection)
  names(collection) <- "one"
  names(collection) # c("one", NA)

  ## extraction
  collection[[1]] # range1
  collection[["1"]] # NULL, does not exist
  collection[["one"]] # range1
  collection[[NA_integer_]] # NULL

  ## subsetting
  collection[numeric()] # empty
  collection[NULL] # empty
  collection[] # identity
  collection[c(TRUE, FALSE)] # first element
  collection[2] # second element
  collection[c(2,1)] # reversed
  collection[-1] # drop first
  collection$one

  ## replacement
  collection$one <- int2
  collection[[2]] <- int1

  ## combining
  col1 <- IntegerList(one = int1, int2)
  col2 <- IntegerList(two = int2, one = int1)
  col3 <- IntegerList(int2)
  append(col1, col2)
  append(col1, col2, 0)
  c(col1, col2, col3)

  ## get the mean for each element
  lapply(col1, mean)



