###################################################
### chunk number 1: 
###################################################
#library(Biobase)
library(GlobalAncova)
data(vantVeer)
data(phenodata)	
data(pathways)	
sI <- sessionInfo()
options(width=70)


###################################################
### chunk number 2: data
###################################################
library(GlobalAncova)
data(vantVeer)
data(phenodata)	
data(pathways)	
formula <- ~ grade + metastases + ERstatus


###################################################
### chunk number 3: sequential
###################################################
GlobalAncova.decomp(xx = vantVeer, formula = formula, model.dat = phenodata, method = "sequential")


###################################################
### chunk number 4: 
###################################################
formula2 <- ~ ERstatus + metastases + grade
GlobalAncova.decomp(xx = vantVeer, formula = formula2, model.dat = phenodata, method = "sequential")


###################################################
### chunk number 5: type3
###################################################
GlobalAncova.decomp(xx = vantVeer, formula = formula, model.dat = phenodata, method = "type3")


###################################################
### chunk number 6: pathw
###################################################
GlobalAncova.decomp(xx = vantVeer, formula = formula, model.dat = phenodata, method = "type3", test.genes = pathways[1:3])


###################################################
### chunk number 7: genewise
###################################################
GlobalAncova.decomp(xx = vantVeer, formula = formula, model.dat = phenodata, test.genes = pathways[[1]][1:3], genewise = TRUE)


###################################################
### chunk number 8: plotseq eval=FALSE
###################################################
## Plot.sequential(vantVeer, formula = ~ ERstatus + metastases + grade, model.dat = phenodata, test.genes = pathways[[3]], name.geneset = "cell cycle pathway")


###################################################
### chunk number 9: 
###################################################
Plot.sequential(vantVeer, formula = ~ ERstatus + metastases + grade, model.dat = phenodata, test.genes = pathways[[3]], name.geneset = "cell cycle pathway")


###################################################
### chunk number 10: combplot eval=FALSE
###################################################
## Plot.all(vantVeer, formula = ~ ERstatus + metastases + grade, model.dat = phenodata, test.genes = pathways[[3]], name.geneset = "cell cycle pathway")


###################################################
### chunk number 11: 
###################################################
Plot.all(vantVeer, formula = ~ ERstatus + metastases + grade, model.dat = phenodata, test.genes = pathways[[3]], name.geneset = "cell cycle pathway")


###################################################
### chunk number 12: pairwise
###################################################
pair.compare(xx = vantVeer, formula = ~ grade, model.dat = phenodata, group = "grade", perm = 100)


###################################################
### chunk number 13: 
###################################################
data(colon.tumour)


###################################################
### chunk number 14: groene
###################################################
data(colon.tumour)
data(colon.normal)
data(colon.pheno)
formula <- ~ UICC.stage + sex + location
GlobalAncova.decomp(xx = colon.tumour, formula = formula, model.dat = colon.pheno, method = "type3")


###################################################
### chunk number 15: diff
###################################################
GlobalAncova.decomp(xx = colon.tumour - colon.normal, formula = formula, model.dat = colon.pheno, method = "type3")


###################################################
### chunk number 16: zz
###################################################
GlobalAncova.decomp(xx = colon.tumour, formula = formula, model.dat = colon.pheno, method = "all", zz = colon.normal)


###################################################
### chunk number 17: zzgw
###################################################
GlobalAncova.decomp(xx = colon.tumour, formula = formula, model.dat = colon.pheno, method = "all", zz = colon.normal, zz.per.gene = TRUE)


