### Name: densityProfile
### Title: Density profiles
### Aliases: densityProfile plot.profile
### Keywords: utilities

### ** Examples


  s <- ""
  for(i in 1:10)
     s <- paste(s, randomSeq(n=100),randomSeq(prob=c(0.3,1,1,1,0)/3.3,n=100),sep="")
 
  placeString(s,seqno=0)

  dens <- densityProfile(ori=200*(1:10)-100,from=200*(0:9)+1,to=200*(1:10),
              seqno=0, fun=seqSkew,nbinL=10,nbinR=10,sizeBin=10)

  plot(dens$skta,main="TA skew")

  ## Example with flagged 'N'

  ## We create a sequence with a biais every 100 nucleotides
  s <- ""
  for(i in 1:10)
     s <- paste(s, randomSeq(n=100),randomSeq(prob=c(0.3,1,1,1,0.2)/3.5,n=100),sep="")
 
  placeString(s,seqno=1)

  dens2 <- densityProfile(ori=200*(1:10)-100,from=200*(0:9)+1,to=200*(1:10),
              seqno=1, fun=compoSeq,nbinL=10,nbinR=10,sizeBin=10)

  plot(dens2$T,main="#T")

  ## The same but more permissive (allow 4 N in each bin)

  dens3 <- densityProfile(ori=200*(1:10)-100,from=200*(0:9)+1,to=200*(1:10),
              seqno=1, fun=compoSeq,nbinL=10,nbinR=10,sizeBin=10,threshold=4)

  plot(dens3$T,main="#T")

  ## Show numbers
  dens

  dens2

  dens3



